variable "account" {
  description = "the human readable account name (used for tagging)"
  type        = string
  default     = "vidcs-dev"
}

variable "region" {
  description = "The region you're building this PCA instance in"
  type        = string
  default     = "us-west-2"
}

variable "service-acct-icp-leaf-role" {
  description = "ARN of the service account role fetching leaf certs"
  type        = string
}

variable "owner" {
  description = "the human readable account owner (used for tagging)"
  type        = string
  default     = "video core services"
}

variable "service-name" {
  description = "a single word service name, used for resoure naming"
  type        = string
  default     = "foobare"
}

variable "service-endpoint" {
  description = "the dns name of your service endpoint, used as certificate CN"
  type        = string
  default     = "staging.us-west-2.foobare.live-video.net"
}

variable "root-maintenance-assume-isengardid" {
  description = "the sts:ExternalId allowed to assume the icp-root-maintenance role"
  type        = string
}

variable "intermediate-maintenance-assume-isengardid" {
  description = "the sts:ExternalId allowed to assume the icp-intermediate-maintenance role"
  type        = string
}

variable "service-leaf-issuance-assume-isengardid" {
  description = "the sts:ExternalId allowed to assume the icp-service-leaf-issuance role"
  type        = string
}

variable "root-ca-generation" {
  description = "the version of root CA certificate"
  type        = number
  default     = 1
}

variable "intermediate-ca-generation" {
  description = "the version of intermediate CA certificate"
  type        = number
  default     = 1
}


# defaults that should not change
variable "src" {
  type    = string
  default = "video-coreservices/tf-mod-icp"
}

variable "video_organization_id" {
  type    = string
  default = "o-pa7on1mit6"
}

variable "ca-key-algo" {
  description = "the key algorithm for PCA instances"
  type        = string
  default     = "EC_prime256v1"
  validation {
    condition     = contains(["RSA_2048", "RSA_4096", "EC_prime256v1", "EC_prime384v1"], var.ca-key-algo)
    error_message = "Error: ca-key-algo must be one of RSA_2048, RSA_4096, EC_prime256v1 or EC_prime384v1."
  }
}

variable "csr-key-algo" {
  description = "the key algorithm for certificate requests"
  type        = string
  default     = "ECDSA"
  validation {
    condition     = contains(["RSA", "ECDSA"], var.csr-key-algo)
    error_message = "Error: csr-key-algo must be one of RSA or ECDSA."
  }
}

variable "csr-key-curve" {
  description = "the ecdsa curve for ECDSA certificate requests"
  type        = string
  default     = "P256"
  validation {
    condition     = contains(["P224", "P256", "P384", "P521"], var.csr-key-curve)
    error_message = "Error: csr-key-curve must be one of RSA or ECDSA."
  }
}

variable "csr-key-bits" {
  description = "the key size for RSA certificate requests"
  type        = string
  default     = "2048"
  validation {
    condition     = contains(["2048", "4096"], var.csr-key-bits)
    error_message = "Error: csr-key-bits must be one of 2048 or 4096."
  }
}

variable "signing-algo" {
  description = "the signing algorithm for certificates"
  type        = string
  default     = "SHA256WITHECDSA"
  validation {
    condition     = contains(["SHA256WITHECDSA", "SHA384WITHECDSA", "SHA512WITHECDSA", "SHA256WITHRSA", "SHA384WITHRSA", "SHA512WITHRSA"], var.signing-algo)
    error_message = "Error: signing-algo must be one of SHA256WITHECDSA, SHA384WITHECDSA, SHA512WITHECDSA, SHA256WITHRSA, SHA384WITHRSA or SHA512WITHRSA."
  }
}

variable "root-ca-validity" {
  description = "length of root ca validity in years"
  type        = number
  default     = 10
}

variable "intermediate-ca-validity" {
  description = "length of intermediate ca validity in years"
  type        = number
  default     = 5
}

variable "leaf-validity" {
  description = "length of leaf certificate validity in years"
  type        = number
  default     = 1
}

variable "crl-expiration" {
  description = "crl expiration time in days"
  type        = number
  default     = 7
}


