# tf-mod-jenkins-role
Creates IAM resources that allow devinfra's jenkins to AssumeRole the role you wish to create.

Also a couple default bells and whistles that can be enabled if you don't want to form other custom policies.

## Usage

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:-----:|
| iam_role_name | The name of the IAM role that will be outfitted with the correct jenkins permissions | `string` |  | yes |
| s3_bucket_arn| (optional) The arn of an S3 bucket to allow Jenkins to push code to. If left empty, policy is not defined | `string` | `""` | no |


### Outputs

| Name | Description |
|------|-------------|
| jenkins\_iam\_role| The IAM role arn created by the module that gives Jenkins infra trust |
| jenkins\_s3\_iam\_policy | If specificed, the IAM policy arn created by the module that gives Jenkins infra permission to push to the S3 bucket you inputed |


### Usage Examples

Just create an IAM role:
```.hcl
module "jenkins" {
  source        = git@git.xarth.tv:video-coreservices/tf-mod-jenkins-role.git
  iam_role_name = "the-iam-role-i-want-to-make"
}
```

Give S3 permissions:
```.hcl
module "jenkins" {
  source        = git@git.xarth.tv:video-coreservices/tf-mod-jenkins-role.git
  iam_role_name = "the-iam-role-i-want-to-make"
  s3_bucket_arn = "arn:aws:s3:::the-bucket-i-want-to-give-perms-to"
}
```
