# IAM infra that allows Jenkins to do common jenkins things
terraform {
  required_version = ">= 0.12.20"
}

data "aws_iam_policy_document" "allow_jenkins_account" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type = "AWS"
      identifiers = [
        "arn:aws:iam::043714768218:role/jenkins-prod-master",
        "arn:aws:iam::043714768218:role/jenkins-prod-slave"
      ]
    }
  }
}

resource "aws_iam_role" "jenkins_iam_role" {
  name               = var.iam_role_name
  assume_role_policy = data.aws_iam_policy_document.allow_jenkins_account.json
}

# Optional: Policy to allow S3 access to Jenkins of a user-inputted bucket arn
resource "aws_iam_policy" "s3_jenkins_iam_policy" {
  count = var.s3_bucket_arn != "" ? 1 : 0
  name  = "${var.iam_role_name}-jenkins-allow-s3"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "s3:*"
      ],
      "Effect": "Allow",
      "Resource": ["${var.s3_bucket_arn}", "${var.s3_bucket_arn}/*"]
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "s3_jenkins_attach" {
  count      = var.s3_bucket_arn != "" ? 1 : 0
  role       = aws_iam_role.jenkins_iam_role.name
  policy_arn = element(concat(aws_iam_policy.s3_jenkins_iam_policy.*.arn, tolist([""])), 0)
  depends_on = [
    aws_iam_policy.s3_jenkins_iam_policy
  ]
}
