# Lambda Codepipeline Terraform

This module sets up infrastructure that supports a codepipeline that includes 3 stages:
* A source step that polls for code changes from an S3 bucket and subfolder you specify.
* A build step that packages up the lambda code and dependencies, forms the candidate appspec, and uploads the resulting configuration to lambda as a new version.
* A deploy step which does a gradual deployment (weighted alias -> version) of the lambda to the latest version.

---

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements from Consuming Lambdas](#requirements-from-consuming-lambdas)
- [Terraform](#terraform)
  - [Requirements](#requirements)
  - [Providers](#providers)
  - [Modules](#modules)
  - [Inputs](#inputs)
  - [Outputs](#outputs)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Requirements from Consuming Lambdas

The module requires you to supply an existing lambda ARN and an existing codesource bucket and optionally a subfolder (which by default represents the `main` branch of a git repository). The mechanism that pushes updated content to your S3 bucket is the responsibility of the IAC or CD that manages those pieces. E.g.:

1. Updating code via a tf deploy https://git.xarth.tv/video-coreservices/tf-mod-dns-sqs-lambda

Updates are expected in a zip file called `SourceArtifact.zip` in your bucket's subfolder and must include the following:

1. Your python lambda code, of course :)
1. A `requirements.txt` to list requirements. The build step will automatically install dependencies from a requirements.txt.
1. An `appspec.yaml`. Copy paste this:

   ```
   version: 0.0
   Resources:
     - ServiceFunction:
         Type: AWS::Lambda::Function
         Properties:
           Name: "LAMBDAFUNCTIONNAME"
           Alias: "PROD"
           CurrentVersion: CURRENTREPLACE
           TargetVersion: TARGETREPLACE
   ```

# Terraform

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

No requirements.

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | n/a |

## Modules

No modules.

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_codebuild_timeout"></a> [codebuild\_timeout](#input\_codebuild\_timeout) | Max timeout for a build to complete in mins | `number` | `5` | no |
| <a name="input_codedeploy_deployment_strategy"></a> [codedeploy\_deployment\_strategy](#input\_codedeploy\_deployment\_strategy) | The codedeploy deployment strategy you want to use. | `string` | `"CodeDeployDefault.LambdaLinear10PercentEvery1Minute"` | no |
| <a name="input_codesource_bucket_id"></a> [codesource\_bucket\_id](#input\_codesource\_bucket\_id) | The name of your S3 bucket. | `string` | n/a | yes |
| <a name="input_codesource_bucket_subfolder"></a> [codesource\_bucket\_subfolder](#input\_codesource\_bucket\_subfolder) | The name of your S3 bucket. | `string` | `"main"` | no |
| <a name="input_env"></a> [env](#input\_env) | Service environment - (prod\|staging) | `string` | n/a | yes |
| <a name="input_lambda_function_name"></a> [lambda\_function\_name](#input\_lambda\_function\_name) | The name of your lambda function you will integrate with the pipeline. | `string` | n/a | yes |
| <a name="input_region"></a> [region](#input\_region) | The AWS region this service will be deployed. | `string` | n/a | yes |
| <a name="input_repo_src"></a> [repo\_src](#input\_repo\_src) | The git source of your terraform. Used to tag taggable resources. | `any` | n/a | yes |
| <a name="input_security_group_ids"></a> [security\_group\_ids](#input\_security\_group\_ids) | A list of security groups that applies to your networking config. Leave `null` if not required. | `list(string)` | `null` | no |
| <a name="input_service_id"></a> [service\_id](#input\_service\_id) | The name of your application | `string` | n/a | yes |
| <a name="input_subnet_ids"></a> [subnet\_ids](#input\_subnet\_ids) | A list of subnets your infrastructure will run under. Leave `null` if not required. | `list(string)` | `null` | no |
| <a name="input_vpc_id"></a> [vpc\_id](#input\_vpc\_id) | The ID of the VPC that your infrastructure will run under. Leave `null` if not required. | `string` | `null` | no |

## Outputs

| Name | Description |
|------|-------------|
| <a name="output_codepipeline_arn"></a> [codepipeline\_arn](#output\_codepipeline\_arn) | The codepipeline arn |
| <a name="output_codepipeline_name"></a> [codepipeline\_name](#output\_codepipeline\_name) | The codepipeline name |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
