resource "aws_codebuild_project" "service_codebuild_project" {
  name          = "${var.service_id}-build"
  description   = "Builds the service code, updates appspec, upload new deployment version to Lambda"
  build_timeout = var.codebuild_timeout
  service_role  = aws_iam_role.service_codebuild_role.arn

  artifacts {
    type = "NO_ARTIFACTS"
  }

  environment {
    compute_type    = "BUILD_GENERAL1_SMALL"
    image           = "aws/codebuild/standard:4.0"
    type            = "LINUX_CONTAINER"
    privileged_mode = "true"
  }

  source {
    type     = "S3"
    location = "${var.codesource_bucket_id}/${var.codesource_bucket_subfolder}"
    buildspec = templatefile("${path.module}/files/buildspec.yaml.tpl",
      {
        service_id           = var.service_id,
        release_bucket       = aws_s3_bucket.service_release_bucket.id,
        lambda_function_name = var.lambda_function_name,
      }
    )
  }

  dynamic "vpc_config" {
    for_each = var.vpc_id == null ? tomap({}) : tomap({ "dummy" = "if vpc required" })

    content {
      vpc_id             = var.vpc_id
      subnets            = var.subnet_ids
      security_group_ids = var.security_group_ids
    }
  }

  tags = local.common_tags
}
