resource "aws_codedeploy_app" "service_codedeploy_app" {
  compute_platform = "Lambda"
  name             = "${var.service_id}-deploy"
}

resource "aws_codedeploy_deployment_group" "service_codedeploy_group" {
  app_name               = aws_codedeploy_app.service_codedeploy_app.name
  deployment_group_name  = "${var.service_id}-deployment-group"
  service_role_arn       = aws_iam_role.service_codedeploy_role.arn
  deployment_config_name = var.codedeploy_deployment_strategy

  auto_rollback_configuration {
    enabled = true
    events  = ["DEPLOYMENT_FAILURE"]
  }

  deployment_style {
    deployment_option = "WITH_TRAFFIC_CONTROL"
    deployment_type   = "BLUE_GREEN"
  }
}
