resource "aws_codepipeline" "service_codepipeline" {
  name     = "${var.service_id}-${var.env}-pipeline"
  role_arn = aws_iam_role.service_codepipeline_role.arn

  artifact_store {
    location = aws_s3_bucket.service_codepipeline_bucket.bucket
    type     = "S3"
  }


  stage {
    name = "Source"

    action {
      name             = "PullUpdatesFromS3"
      category         = "Source"
      owner            = "AWS"
      provider         = "S3"
      version          = "1"
      output_artifacts = ["SourceArtifact"]

      configuration = {
        PollForSourceChanges = "true"
        S3Bucket             = var.codesource_bucket_id
        S3ObjectKey          = "${var.codesource_bucket_subfolder}/SourceArtifact.zip"
      }
    }
  }

  stage {
    name = "Build"

    action {
      name             = "BuildLambda"
      category         = "Build"
      owner            = "AWS"
      provider         = "CodeBuild"
      input_artifacts  = ["SourceArtifact"]
      output_artifacts = ["BuildArtifact"]
      version          = "1"

      configuration = {
        ProjectName = aws_codebuild_project.service_codebuild_project.name
      }
    }
  }

  stage {
    name = "Deploy"

    action {
      name             = "DeployLambda"
      category         = "Deploy"
      owner            = "AWS"
      provider         = "CodeDeploy"
      input_artifacts  = ["BuildArtifact"]
      output_artifacts = []
      version          = "1"

      configuration = {
        ApplicationName     = aws_codedeploy_app.service_codedeploy_app.name
        DeploymentGroupName = aws_codedeploy_deployment_group.service_codedeploy_group.deployment_group_name
      }
    }
  }
}
