---
version: 0.2
phases:
  install:
    runtime-versions:
      python: 3.7

  pre_build:
    commands:
    - echo Performing prebuild steps...
    - pip install --upgrade pip
    - pip install pipenv --user
    - pip install awscli

  build:
    commands:
    - echo Build started on `date`

    - echo Installing code dependencies..
    - mkdir build && rsync -av --progress . build --exclude build --exclude=".*" && cd build
    - pip install --target . -r requirements.txt

    # Modify Lambda because pipeline does not support this
    - mkdir release && zip -r release/${service_id}-$CODEBUILD_BUILD_NUMBER.zip . -x release/ && cd release
    - echo Uploading new code to s3
    - export LAMBDA_FUNCTION_NAME=${lambda_function_name}
    - aws s3 sync . "s3://${release_bucket}/release-$CODEBUILD_BUILD_NUMBER" && cd ../ && rm -rf release
    - CURRENT_LAMBDA_VERSION=$(aws lambda get-alias --function-name $LAMBDA_FUNCTION_NAME --name PROD --region $AWS_REGION | jq .FunctionVersion)
    - echo Currently running lambda version is $CURRENT_LAMBDA_VERSION
    - echo Publishing new release of lambda..
    - TARGET_LAMBDA_VERSION=$(aws lambda update-function-code --region $AWS_REGION --function-name $LAMBDA_FUNCTION_NAME --publish --s3-bucket "${release_bucket}" --s3-key "release-$CODEBUILD_BUILD_NUMBER/${service_id}-$CODEBUILD_BUILD_NUMBER.zip" | jq .Version)
    - echo Next target lambda version is $TARGET_LAMBDA_VERSION

    # Configure appspec.yaml with the correct deployment info
    - cd ../
    - sed -i'.bak' "s/LAMBDAFUNCTIONNAME/$LAMBDA_FUNCTION_NAME/g" appspec.yaml
    - sed -i'.bak' "s/CURRENTREPLACE/$CURRENT_LAMBDA_VERSION/g" appspec.yaml
    - sed -i'.bak' "s/TARGETREPLACE/$TARGET_LAMBDA_VERSION/g" appspec.yaml
    - cat appspec.yaml

  post_build:
    commands:
    - echo Build completed on `date`

artifacts:
  name: BuildArtifact
  files:
    - 'appspec.yaml'
