variable "env" {
  description = "Service environment - (prod|staging)"
  type        = string
}

variable "region" {
  description = "The AWS region this service will be deployed."
  type        = string
}

variable "repo_src" {
  description = "The git source of your terraform. Used to tag taggable resources."
}

variable "service_id" {
  description = "The name of your application"
  type        = string
}

variable "lambda_function_name" {
  description = "The name of your lambda function you will integrate with the pipeline."
  type        = string
}

variable "codesource_bucket_id" {
  description = "The name of your S3 bucket."
  type        = string
}

variable "codesource_bucket_subfolder" {
  description = "The name of your S3 bucket."
  type        = string
  default     = "main"
}

variable "codebuild_timeout" {
  description = "Max timeout for a build to complete in mins"
  type        = number
  default     = 5
}

variable "vpc_id" {
  description = "The ID of the VPC that your infrastructure will run under. Leave `null` if not required."
  type        = string
  default     = null
}

variable "subnet_ids" {
  description = "A list of subnets your infrastructure will run under. Leave `null` if not required."
  type        = list(string)
  default     = null
}

variable "security_group_ids" {
  description = "A list of security groups that applies to your networking config. Leave `null` if not required."
  type        = list(string)
  default     = null
}

variable "codedeploy_deployment_strategy" {
  description = "The codedeploy deployment strategy you want to use."
  type        = string
  default     = "CodeDeployDefault.LambdaLinear10PercentEvery1Minute"
}

locals {
  environment_map = {
    prod    = "production"
    stage   = "staging"
    staging = "staging"
    dev     = "development"
  }

  environment = local.environment_map[var.env]

  common_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = var.service_id
    Environment = local.environment
    Source      = var.repo_src
  }
}
