# live-video delegation tf module

This module helps create and manage `<service>.live-video.a2z.com`, `<service>.live-video-ext.a2z.com`, `<service>.hls.live-video.net` and `<service>.live-video.net` service DNS zones, subdomain zones, and subdomain delegations.

Service DNS zones are expected to follow the following convention:

For `live-video.a2z.com` and `live-video-ext.a2z.com`:

* `<service>.live-video.a2z.com`
* `<region>.<env>.<service>.live-video.a2z.com`
* `<service>.live-video-ext.a2z.com`
* `<region>.<env>.<service>.live-video-ext.a2z.com`

For `live-video.net` and `hls.live-video.net`:

* `<service>.live-video.net`
* `<service>.hls.live-video.net`

_Note: In general, pop level delegation for hls.live-video.net is managed via [tf-io-hls-dns](https://git.xarth.tv/video-coreservices/tf-io-hls-dns). However, other services such as CDN delegation, or "metrics" collecting pop (to avoid adblocker) would require delegations to other accounts outside of `twitch-hls-dns` account_

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**

- [Requirements](#requirements)
- [Use Cases](#use-cases)
  - [Completely New Setup](#completely-new-setup)
  - [Updating An Existing Setup](#updating-an-existing-setup)
  - [Adding to An Existing Setup](#adding-to-an-existing-setup)
- [Request a service subdomain](#request-a-service-subdomain)
  - [Example code](#example-code)
  - [Example output](#example-output)
  - [Further Steps](#further-steps)
  - [Important Note about Security and Domain Deletion](#important-note-about-security-and-domain-deletion)
- [Creating and Managing service subdomain delegations](#creating-and-managing-service-subdomain-delegations)
- [Modules Provided](#modules-provided)
  - [primary](#primary)
  - [iam](#iam)
  - [delegate](#delegate)
- [Development](#development)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Requirements

* `terraform >= 0.12.20`

# Use Cases

The following use cases assume that your project is or will be following the current guidance around establishing one AWS account per region and deployment stage.

## Completely New Setup

- First, follow the instructions under [Request a service subdomain](#request-a-service-subdomain)
  - This bootstraps the resources needed to tie your project into the upstream subdomain. DO NOT SKIP.
- Second, run the IAM terraform module for your DNS AWS account to provision the `lvs-dns-delegation` role.
  - Make sure to adjust your Isengard credentials to those for your DNS AWS account.
- Next, run the same IAM module for your subdomain AWS account(s) - adjusting your Isengard credentials to each subdomain account.
- Once the IAM roles are in place for both the DNS AWS account and your subdomain AWS account, run the provided delegate module for your DNS AWS account.

## Updating An Existing Setup

The terraform modules were designed for a one-time setup. Following the recommended account structure (i.e: one DNS account for the service subdomain, and one service account per AWS region/environment delegation of your service subdomain) will prevent a need to update setups.

If you need to migrate supported delegate subdomains (i.e. `...live-video*.a2z.com`) between accounts and are unsure how this will impact your DNS structure, reach out to #video-coreservices.

## Adding to An Existing Setup

- You should already have the service subdomain setup in your DNS AWS account. Please verify before continuing.
  - You can do so by checking for your project under the appropriate directory here: [https://git.xarth.tv/video-coreservices/tf-io-live-video-dns/tree/master/services]
- Verify that your DNS AWS account has the `lvs-dns-delegation` role.
- You will need to also provision `lvs-dns-delegation` with the provided Terraform module for the subdomain AWS accounts you are setting up.
- Once the IAM roles are in place for both the DNS AWS account and your subdomain AWS account, run the provided delegate module for your DNS AWS account.

Once you have completed one of the processes above, we recommend that you verify your changes are in place from the AWS web console.

- Under the IAM roles menu, make sure that `lvs-dns-delegation` is in place for both your AWS DNS account and the subdomain accounts you provisions.
- You can verify your service subdomain by using the CLI tool `dig`.
  - Here is an example of it's usage: `dig +short NS us-east-1.prod.hosesapi.live-video.a2z.com`.
  - If you are unfamiliar with dig, here is a primer: [https://linuxhandbook.com/dig-command/].
  - This should return a list of NS entries, which we will double check against in the next step.
- Log into your account's Route53 section. Find the subdomain you set up before and make sure that they match the NS records from the previous step.

# Request a service subdomain

Please follow these steps to request a new subdomain `<service>.live-video.a2z.com` or `<service>.live-video-ext.a2z.com` or `<service>.live-video.net` or `<service>.hls.live-video.net` to be delegated for your service.

1. Create a [new AWS account](https://wiki.twitch.com/display/AD/How+to+Set+Up+a+New+AWS+Account) specifically to manage this DNS zone.
1. Run [terraform module](./primary) to setup a new Route53 hosted zone in this new account.
   - E.g., at minimum:
       - Install [terraform](https://www.terraform.io/downloads.html).
       - Create a `main.tf` file and populate it with the [example code](#example-code) below.
       - Obtain and export AWS IAM credentials to your console. Temporary credentials can be obtained via [Isengard](https://isengard.amazon.com/). IAM role must have at least the following permissions:
            - Create new route53 hosted zone
            - Create new IAM role and attach IAM policy
       - Then, using the AWS credentials that you just created for the service:
           - Run `export AWS_REGION=<region>`
             - `region` may be any valid AWS region as it's simply a required argument for the AWS provider. The resources the module creates are global so the module is region agnostic.
           - Run `terraform init`
           - Run `terraform apply`
1. Open a [VIDCS](https://jira.twitch.com/browse/VIDCS) ticket and provide the the following:
   * The name of the account. E.g. `twitch-video-puppet-dns`
   * The name of the team that owns this service. E.g. `video-coreservices`
   * The terraform output (E.g. [example output](#example-output) provided below)

Refer example code and output below.

## Example code
```hcl
variable "service" {
  description = "The name of the service"
}

module "service" {
  source  = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//primary?ref=v1.0.9"
  service = var.service
  domain  = "live-video.a2z.com"
}

output "zone" {
  value = module.service
}
```

## Example output

```bash
Outputs:

zone = {
  "account_id" = "489622251736"
  "account_role" = "tf-deploy"
  "primary" = {
    "zone" = {
      "id" = "Z3PKTS7CGUDEVJ"
      "name" = "puppet.live-video.a2z.com"
      "name_servers" = [
        "ns-1051.awsdns-03.org",
        "ns-1949.awsdns-51.co.uk",
        "ns-367.awsdns-45.com",
        "ns-576.awsdns-08.net",
      ]
    }
  }
}
```

## Further Steps
Once the subdomain has been delegated, you can freely create new records or further delegate subdomains to other AWS accounts.

To help manage additional delegations (e.g. delegating `us-west-2.prod.awesomeservice.live-video.a2z.com` to another AWS account), you can utilize [video-coreservices/tf-mod-live-video-dns-delegation module](https://git.xarth.tv/video-coreservices/tf-mod-live-video-dns-delegation).

For reference, VidCS uses [this codebase](https://git.xarth.tv/video-coreservices/tf-io-vidcs-dns-delegations) to manage VidCS delegations.

## Important Note about Security and Domain Deletion

If you decide in the future that you no longer require your domain name and its hosted zone, please contact us - [VIDCS](https://jira.twitch.com/browse/VIDCS). **Important**: please wait for us to confirm that we’ve deleted the delegation before you delete the Route 53 zone. If you discover that you’ve already deleted your hosted zone by mistake, please let us know ASAP.

It is important that we remove the nameserver delegation first, before you delete the hosted zone, because the hosted zone is what “reserves” those name servers for your exclusive use. As soon as you delete the zone, its name servers are “released” and Route 53 may reassign them to someone else. We don’t want that to happen while we are still delegating control of your domain to them! If this situation occurs, then it creates the potential for an attacker to attempt to seize control of your domain name.

Due to these risks, we reserve the right to periodically scan AWS accounts that host the delegated domains, using the IAM Role created (automatically) during onboarding, to ensure that the expected Route 53 zone exists, and that our delegation records match its name servers. (Please contact us if this concerns you or is a surprise.)

# Creating and Managing service subdomain delegations

1. Ensure AWS account for `<region>.<env>.<service>.live-video.a2z.com` `lvs-dns-delegation` IAM role has been setup. Refer [modules/iam](./modules/iam).
1. Create new subdomain and DNS record that will delegate the subdomain to `<region>.<env>.<service>.live-video.a2z.com`. Refer [delegate](./delegate) module.

# Modules Provided

This repository provides 3 different modules to help manage your DNS subdomains and delegations.

## [primary](./primary)

Used for setting up primary service Route53 zone `<service>.live-video.a2z.com` or `<service>.live-video-ext.a2z.com` or `<service>.hls.live-video.net` or `<service>.live-video.net`. This should be in its own separate AWS account, and only used once.

## [iam](./modules/iam)

Used to setup the appropriate IAM role and permissions to allow [delegate](./delegate) module to be used. This should be setup once for each `<region>.<env>.<service>.live-video.a2z.com` or `<region>.<env>.<service>.live-video-ext.a2z.com` AWS account.

Please note that the IAM role should be provisioned for both your DNS and subdomain AWS accounts.

## [delegate](./delegate)

Used to setup `<component>.<region>.<env>.<service>.live-video.a2z.com`, `<component>.<region>.<env>.<service>.live-video-ext.a2z.com`, `<region>.<env>.<service>.live-video.a2z.com` or ``<region>.<env>.<service>.live-video-ext.a2z.com`` delegation zones and FQDN records in the primary `<service>.live-video.a2z.com` or `<service>.live-video-ext.a2z.com` Route53 Hosted zone. This should be run in the same AWS account as the primary module.

Please note that you should run this **after** you have set up your IAM role for both your DNS and subdomain accounts.

# Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`terraform-docs`](https://github.com/segmentio/terraform-docs#installation)

Run `pre-commit install` to install `pre-commit` hook.
