<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**  *generated with [DocToc](https://github.com/thlorenz/doctoc)*

- [Delegate Regional Environment Subdomains](#delegate-regional-environment-subdomains)
  - [Requirements](#requirements)
  - [Parameters](#parameters)
  - [Requirements](#requirements-1)
  - [Providers](#providers)
  - [Modules](#modules)
  - [Resources](#resources)
  - [Inputs](#inputs)
  - [Outputs](#outputs)
  - [Example Usage](#example-usage)
  - [Example Output](#example-output)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Delegate Regional Environment Subdomains

This module will perform the following:

1. Create `<region>.<env>.<service>.live-video.a2z.com` or `<component>.<region>.<env>.<service>.live-video.a2z.com` Route53 hosted zone in the respective AWS account.
1. Create and manage records in `<service>.live-video.a2z.com` which will delegate `<region>.<env>.<service>.live-video.a2z.com` or `<component>.<region>.<env>.<service>.live-video.a2z.com` to the nameservers of the created Route53 hosted zone above.

## Requirements

Ensure the AWS account where `<region>.<env>.<service>.live-video.a2z.com` will be created has the appropriate IAM roles setup. Refer [IAM module](../modules/iam/README.md) documentation.

## Parameters

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >= 0.12 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | n/a |
| <a name="provider_null"></a> [null](#provider\_null) | n/a |

## Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_defaults"></a> [defaults](#module\_defaults) | ../modules/defaults |  |
| <a name="module_subdomain"></a> [subdomain](#module\_subdomain) | ../modules/zone |  |

## Resources

| Name | Type |
|------|------|
| [aws_route53_record.comment](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/route53_record) | resource |
| [aws_route53_record.subdomain](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/route53_record) | resource |
| [null_resource.validate_account](https://registry.terraform.io/providers/hashicorp/null/latest/docs/resources/resource) | resource |
| [null_resource.validate_domain](https://registry.terraform.io/providers/hashicorp/null/latest/docs/resources/resource) | resource |
| [null_resource.validate_env](https://registry.terraform.io/providers/hashicorp/null/latest/docs/resources/resource) | resource |
| [null_resource.validate_region](https://registry.terraform.io/providers/hashicorp/null/latest/docs/resources/resource) | resource |
| [aws_caller_identity.account](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/caller_identity) | data source |
| [aws_route53_zone.primary](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/route53_zone) | data source |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_component"></a> [component](#input\_component) | The component name. (api, ui, etc.) | `string` | `""` | no |
| <a name="input_domain"></a> [domain](#input\_domain) | The root domain of the service. Valid options: live-video.a2z.com, live-video.net | `string` | `"live-video.a2z.com"` | no |
| <a name="input_env"></a> [env](#input\_env) | The service environment. (dev, staging, or prod) | `any` | n/a | yes |
| <a name="input_primary_account_id"></a> [primary\_account\_id](#input\_primary\_account\_id) | The account id of the account that this subdomain will be delegated from. This is the primary account responsible for the domain. | `any` | n/a | yes |
| <a name="input_region"></a> [region](#input\_region) | The AWS region where the service will be | `any` | n/a | yes |
| <a name="input_service"></a> [service](#input\_service) | The name of the service | `any` | n/a | yes |
| <a name="input_subdomain_account_id"></a> [subdomain\_account\_id](#input\_subdomain\_account\_id) | The account id where the Route53 subdomain lives | `any` | n/a | yes |
| <a name="input_subdomain_account_name"></a> [subdomain\_account\_name](#input\_subdomain\_account\_name) | The name of the account that this subdomain will be delegated to | `any` | n/a | yes |
| <a name="input_subdomain_account_role"></a> [subdomain\_account\_role](#input\_subdomain\_account\_role) | The name of the role to assume in the subdomain account | `string` | `"lvs-dns-delegation"` | no |
| <a name="input_ttl"></a> [ttl](#input\_ttl) | DNS record ttl | `number` | `86400` | no |

## Outputs

| Name | Description |
|------|-------------|
| <a name="output_comment"></a> [comment](#output\_comment) | txt record of the account and account\_id of the subdomain that is being delegated |
| <a name="output_records"></a> [records](#output\_records) | The name servers of the subdomain |
| <a name="output_subdomain"></a> [subdomain](#output\_subdomain) | The name of the subdomain that is being delegated |
| <a name="output_ttl"></a> [ttl](#output\_ttl) | TTL of DNS record that points the delegated nameservers |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Example Usage

```hcl
module "delegate_usw2_dev" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//delegate?ref=v1.0.9"

  service = "puppet"
  region  = "us-west-2"
  env     = "dev"

  subdomain_account_name = "twitch-vidcs-dev"
  subdomain_account_id   = "360826418937"
  primary_account_id     = "852505758956"
}

output "delegate_usw2_dev" {
  value = module.delegate_usw2_dev
}
```

## Example Output

```bash
delegate_usw2_dev = {
  "comment" = "Delegated to 360826418937 (twitch-vidcs-dev)"
  "records" = [
    "ns-1405.awsdns-47.org",
    "ns-2024.awsdns-61.co.uk",
    "ns-446.awsdns-55.com",
    "ns-726.awsdns-26.net",
  ]
  "subdomain" = "us-west-2.dev.puppet.live-video.a2z.com"
  "ttl" = 86400
}
```
