variable "service" {
  description = "The name of the service"
}

variable "region" {
  description = "The AWS region where the service will be"
}

variable "env" {
  description = "The service environment. (dev, staging, or prod)"
}

variable "component" {
  description = "The component name. (api, ui, etc.) "
  default     = ""
}

variable "primary_account_id" {
  description = "The account id of the account that this subdomain will be delegated from. This is the primary account responsible for the domain."
}

variable "subdomain_account_id" {
  description = "The account id where the Route53 subdomain lives"
}

variable "subdomain_account_name" {
  description = "The name of the account that this subdomain will be delegated to"
}

variable "subdomain_account_role" {
  description = "The name of the role to assume in the subdomain account"
  default     = "lvs-dns-delegation"
}

variable "domain" {
  description = "The root domain of the service. Valid options: live-video.a2z.com, live-video.net"
  default     = "live-video.a2z.com"
}

variable "ttl" {
  type        = number
  description = "DNS record ttl"
  default     = 86400
}
