# lvs-dns-delegation IAM Role

This module creates `lvs-dns-delegation` IAM role with the following policy:

1. Allow delegator account to read Route53 Hosted Zone information. This helps obtain NS information that is required to delegate zones.
1. Optionally allow the delegator to automatically create zone (`true` by default). This is useful for [delegate](../../delegate) module.

## Parameters

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Providers

| Name | Version |
|------|---------|
| aws | n/a |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:-----:|
| allow\_create\_hosted\_zone | Whether to allow this assumed role to create Route53 Hosted Zone. | `bool` | `true` | no |
| delegator\_account\_id | The AWS account id that delegated this zone | `string` | n/a | yes |
| delegator\_account\_role | The assumed AWS account role that is used to access this account. This should be the value of `account_role` from your Primary Delegation Account, i.e. the same role used to run the terraform primary module | `string` | `"lvs-dns-delegation"` | no |
| description | IAM role description | `string` | `"Used for live-video.a2z.com DNS delegation"` | no |
| subdomain\_account\_role | The name of the role that the delegator account will assume | `string` | `"lvs-dns-delegation"` | no |
| tags | Common tags to be passed | `map` | `{}` | no |

## Outputs

| Name | Description |
|------|-------------|
| role | n/a |

<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Example Usage

```hcl
module "iam" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//modules/iam?ref=v1.0.6"

  delegator_account_id   = "489622251736"
  delegator_account_role = "tf-deploy"
}

output "iam" {
  value = module.iam
}
```

## Example Output

```bash
iam = {
  role = {
    "arn" = "arn:aws:iam::360826418937:role/lvs-dns-delegation"
    "assume_role_policy" = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"\",\"Effect\":\"Allow\",\"Principal\":{\"AWS\":\"arn:aws:iam::489622251736:role/tf-deploy\"},\"Action\":\"sts:AssumeRole\"}]}"
    "create_date" = "2019-08-29T01:48:16Z"
    "description" = "Used for live-video.a2z.com DNS delegation"
    "force_detach_policies" = false
    "id" = "lvs-dns-delegation"
    "max_session_duration" = 3600
    "name" = "lvs-dns-delegation"
    "path" = "/"
    "tags" = {}
    "unique_id" = "AROASHBE2SPZHJYMQBHNL"
  }
}
```
