#################################################
# Common module to generate appropriate IAM roles
#################################################

# Setup IAM roles for upstream delegator to read Route53 information
resource "aws_iam_role" "lvs_dns_delegation" {
  name        = var.subdomain_account_role
  description = var.description

  assume_role_policy = data.aws_iam_policy_document.lvs_dns_sts.json

  tags = var.tags
}

data "aws_iam_policy_document" "lvs_dns_sts" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type        = "AWS"
      identifiers = ["arn:aws:iam::${var.delegator_account_id}:role/${var.delegator_account_role}"]
    }
  }
}

data "aws_iam_policy" "route53_read_only_access" {
  arn = "arn:aws:iam::aws:policy/AmazonRoute53ReadOnlyAccess"
}

resource "aws_iam_role_policy_attachment" "readonly" {
  role       = aws_iam_role.lvs_dns_delegation.name
  policy_arn = data.aws_iam_policy.route53_read_only_access.arn
}

data "aws_iam_policy_document" "route53_create_hosted_zone" {
  count = var.allow_create_hosted_zone == true ? 1 : 0

  statement {
    actions = ["route53:CreatehostedZone"]

    resources = ["*"]
  }
}

resource "aws_iam_role_policy" "route53_create_hosted_zone" {
  count = var.allow_create_hosted_zone == true ? 1 : 0

  name   = "Route53CreateHostedZone"
  role   = aws_iam_role.lvs_dns_delegation.name
  policy = data.aws_iam_policy_document.route53_create_hosted_zone.0.json
}
