variable "delegator_account_id" {
  description = "The AWS account id that delegated this zone"
  type        = string
}

variable "delegator_account_role" {
  description = "The assumed AWS account role that is used to access this account. This should be the value of `account_role` from your Primary Delegation Account, i.e. the same role used to run the terraform primary module"
  type        = string
  default     = "lvs-dns-delegation"
}

variable "subdomain_account_role" {
  description = "The name of the role that the delegator account will assume"
  type        = string
  default     = "lvs-dns-delegation"
}

variable "allow_create_hosted_zone" {
  description = "Whether to allow this assumed role to create Route53 Hosted Zone."
  type        = bool
  default     = true
}

variable "description" {
  description = "IAM role description"
  type        = string
  default     = "Used for live-video.a2z.com DNS delegation"
}

variable "tags" {
  description = "Common tags to be passed"
  type        = map
  default     = {}
}
