terraform {
  required_providers {
    aws = {}
  }
}

### IAM perms to permit assumption
resource "aws_iam_role" "control" {
  name               = "dns-pop-delegation-control"
  description        = "Permit control account to manage pop DNS delegation"
  assume_role_policy = data.aws_iam_policy_document.assume_role_policy.json
}

# Permit twitch-vidcs+pop-delegation-control-dns to manage subdelegations
data "aws_iam_policy_document" "assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type = "AWS"
      identifiers = [
        "arn:aws:iam::362079722421:role/dns-admin", # twitch-vidcs+pop-delegation-control-dns
      ]
    }
  }
}

# Grant this role the necessary powers to perform its job
resource "aws_iam_role_policy_attachment" "route53_fullaccess" {
  role       = aws_iam_role.control.name
  policy_arn = "arn:aws:iam::aws:policy/AmazonRoute53FullAccess"
}

# Don't delete the primary zone ever
data "aws_iam_policy_document" "deny_delete" {
  statement {
    sid       = "DenyPrimaryZoneDeletion"
    effect    = "Deny"
    actions   = ["route53:DeleteHostedZone"]
    resources = ["arn:aws:route53:::hostedzone/${var.primary_zone_arn}"]
  }
}

resource "aws_iam_role_policy" "deny_delete" {
  role   = aws_iam_role.control.name
  policy = data.aws_iam_policy_document.deny_delete.json
}
