# Primary Service Route53 Hosted Zone

This module manages the creation of `<service>.live-video.a2z.com` or `<service>.live-video.net`.

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Parameters](#parameters)
- [Requirements](#requirements)
- [Providers](#providers)
- [Modules](#modules)
- [Resources](#resources)
- [Inputs](#inputs)
- [Outputs](#outputs)
- [Example Usage](#example-usage)
- [Example Output](#example-output)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Parameters

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >= 0.12.20 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | n/a |
| <a name="provider_null"></a> [null](#provider\_null) | n/a |

## Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_defaults"></a> [defaults](#module\_defaults) | ../modules/defaults |  |
| <a name="module_iam"></a> [iam](#module\_iam) | ../modules/iam |  |
| <a name="module_zone"></a> [zone](#module\_zone) | ../modules/zone |  |

## Resources

| Name | Type |
|------|------|
| [null_resource.validate_domain](https://registry.terraform.io/providers/hashicorp/null/latest/docs/resources/resource) | resource |
| [aws_caller_identity.account](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/caller_identity) | data source |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_comment"></a> [comment](#input\_comment) | Useful description to describe the service | `string` | `"Created via tf-mod-live-video-dns-delegation module"` | no |
| <a name="input_domain"></a> [domain](#input\_domain) | The root domain of the service. Valid options: `live-video.a2z.com`, `live-video-ext.a2z.com`, `live-video.net`, `hls.live-video.net` | `string` | `"live-video.a2z.com"` | no |
| <a name="input_service"></a> [service](#input\_service) | The name of the service. This will generate `<service>.live-video.a2z.com` | `string` | n/a | yes |
| <a name="input_tags"></a> [tags](#input\_tags) | Common tags to be passed | `map(any)` | `{}` | no |

## Outputs

| Name | Description |
|------|-------------|
| <a name="output_account_id"></a> [account\_id](#output\_account\_id) | The AWS account id of where this tf is run |
| <a name="output_account_role"></a> [account\_role](#output\_account\_role) | The account role used to run this terraform module |
| <a name="output_primary"></a> [primary](#output\_primary) | The name of the zone |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Example Usage

```hcl
module "service" {
  source  = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//primary?ref=v1.0.6"
  service = "puppet"
  domain  = "live-video.a2z.com"
}

output "zone" {
  value = module.service
}
```

## Example Output

```bash
Outputs:

zone = {
  "account_id" = "489622251736"
  "account_role" = "tf-deploy"
  "primary" = {
    "zone" = {
      "id" = "Z3PKTS7CGUDEVJ"
      "name" = "puppet.live-video.a2z.com"
      "name_servers" = [
        "ns-1051.awsdns-03.org",
        "ns-1949.awsdns-51.co.uk",
        "ns-367.awsdns-45.com",
        "ns-576.awsdns-08.net",
      ]
    }
  }
}
```
