#################################################################
# This should be used to create service Primary Delegation Account
##################################################################

terraform {
  required_version = ">= 0.12.20"
}

module "defaults" {
  source = "../modules/defaults"
}

locals {
  zone_name    = "${var.service}.${var.domain}"
  root_domains = module.defaults.root_domains

  # Map domain to delegator account id and account_role
  domain_iam_map = {
    # twitch-bs-video-lvs-dns@amazon.com
    "live-video.a2z.com" = {
      "account_id"   = "476213502168",
      "account_role" = "lvs-dns-delegation",
    }

    # twitch-bs-video-lvs-dns@amazon.com
    "live-video-ext.a2z.com" = {
      "account_id"   = "093434409684",
      "account_role" = "lvs-dns-delegation",
    }

    # twitch-live-video-net-dns@amazon.com
    "live-video.net" = {
      "account_id"   = "111527861268",
      "account_role" = "lvs-dns-delegation"
    }

    # twitch-hls-dns@amazon.com@amazon.com
    "hls.live-video.net" = {
      "account_id"   = "393787499934",
      "account_role" = "tf-pop-dns-mgmt",
    }

    # twitch-vidcs+ttvnw-net-dns@amazon.com
    "ttvnw.net" = {
      "account_id"   = "623515894823",
      "account_role" = "lvs-dns-delegation"
    }

    # twitch-vidcs+hls-ttvnw-net-dns@amazon.com
    "hls.ttvnw.net" = {
      "account_id"   = "707969931081",
      "account_role" = "tf-pop-dns-mgmt",
    }
  }
}

# Determine role of caller account
data "aws_caller_identity" "account" {}

# Poor man's validation
resource "null_resource" "validate_domain" {
  count = contains(local.root_domains, var.domain) == true ? 0 : "Please provide a valid domain. (live-video.a2z.com|live-video-ext.a2z.com|live-video.net|hls.live-video.net|ttvnw.net|hls.ttvnw.net)"
}

# Setup Primary zone
module "zone" {
  source = "../modules/zone"

  name    = local.zone_name
  comment = var.comment

  tags = merge({ Service = var.service }, var.tags)
}

# Setup IAM role so that primary lvs-dns-delegation can assume to read created zones
module "iam" {
  source = "../modules/iam"

  delegator_account_id   = try(local.domain_iam_map[var.domain].account_id, "")
  delegator_account_role = try(local.domain_iam_map[var.domain].account_role, "")

  allow_create_hosted_zone = false

  description = "Used for ${var.domain} DNS delegation"

  tags = merge({ Service = var.service }, var.tags)
}
