output "primary" {
  description = "The name of the zone"
  value       = module.zone
}

output "account_id" {
  description = "The AWS account id of where this tf is run"
  value       = data.aws_caller_identity.account.account_id
}

output "account_role" {
  description = "The account role used to run this terraform module"
  value       = element(split("/", data.aws_caller_identity.account.arn), 1)
}
