# tf-mod-tls-iam

Consumable terraform milliner IAM role creation module and authoritative mapping module for the placing TLS certs project.

## How to Navigate

The `iam` and `mapping` folders are generic, consumable modules. Feel free to use them in your own tf repositories (please refer to their respective READMEs on HOWTO usage). The `sandstorm` module exists to create vanilla IAM roles in the AWS account sandstorm runs in. It's practical usage is detailed in `test-sandstorm-sse`.

The `consul` and `test-sandstorm-sse` directories are implementations that are practical usages of the aforementioned modules. They live in this repository to keep closely relevant infrastructure in the same repository. They could be migrated elsewhere at any time (ex: `test-sandstorm-sse` to a secdev owned repository, and eventually a video-tools owned repo).

## Intent

As part of the various security efforts, we are required to properly create new sandstorm roles for various production machine classes and manage those role mappings to their relevant milliner service roles. This enables the sandstorm agent on bare metal machines (and underlying sandstorm role) to properly map and assume the milliner service role of that specific machine.

This collection of modules provides development teams a standard consumable module to create their milliner service IAM roles with a degree of flexibility but abide by minimum naming standards to enable configuration automation in terraform and puppet.

Equally important, it exposes shared mapping metadata (i.e: which bare metal pops are mapped to which AWS region and which services have onboarded to run sandstorm using milliner and IAM role mappings) that can be consumed by any other terraform modules (such as milliner-mappings). Within this repository, two use cases, "sandstorm" and "consul", demonstrate effective consumption models of the mappings.
