# Consul

Experimental method to enact authoritative default_region mapping in consul k/v instead of facter. This experiment is ONLY meant to support the default_region use case. Any other application specific pop to region mapping that does not align with default_region's functionality should not follow this pattern. I won't be applying any of this in this round. I just had the idea so wanted to write it out to have in our back pocket.

## Methodology

1. Create a kv /vidcs/default_region in each consul datacenter that maps to the AWS region the PoP maps to.
1. Create a kv /vidcs/global_default_region_mapping in each consul datacenter that harbors the same pop to region mapping value.


### Idea

In puppet, instead of using the default_region mapping hash_map, have newly provisioned clients call for the kv values in this order:
- Look for a cached (possibly written on disk value). If the value exists and hasn't bypassed a predetermined expiry period, use the locally cached value.
- If the cached value needs a refresh, call localhost:8500 in the case where a client is already setup with a consul agent to get `/vidcs/default_region`.
- Fallback to the client's consul DC in the case where a client is provisioning and not yet setup with a consul agent to get `/vidcs/default_region`
- Fallback to a `global` consul API endpoint (which we're planning on making represented by all AWS DCs) to get `/vidcs/global_default_region_mapping` and use that value to parse out the client's `default_region` like we do today in facter. This satisfies the case where pop-masters/consul-masters have not yet been provisioned in the DC and there is no consul.


### What this would give us

- A way out of default_region in a hash map in facter.
- A more consistent default_region value not dependent on puppet to be run everywhere and updated everywhere.
- A central place to configure this mapping that is not addressable by existing bare metal and AWS clients via the HTTP API as well as deriving its source of truth from the same source of truth `mapping` module.
