locals {
  # We could include this mapping in the mapping module. Use case seemed specific to consul though and not a "pop" to region mapping kinda thing
  aws_consul_dc_list = {
    us-west-2      = ["us-west2"]
    us-east-1      = ["us-east-1"]
    us-east-2      = ["us-east-2"]
    eu-west-1      = []
    eu-west-2      = ["eu-west-2"]
    ap-southeast-1 = []
  }

  full_consul_dc_map = { for r, dcs in module.mapping.edge_dcs : r => flatten([local.aws_consul_dc_list[r], dcs, module.mapping.origin_dcs[r]]) }

  full_consul_dc_list = flatten(tolist(values(local.full_consul_dc_map))) #I hate this i know
  pop_bringup_exclude = []                                                # Add the PoP you're bringing up to the exclude list when running tf first. Then, remove in a followup PR
  consul_dc_set       = toset(flatten([local.full_consul_dc_list, local.pop_bringup_exclude]))
}

module "mapping" {
  source = "../mapping"
}

provider "consul" {
  address    = "api.us-west-2.prod.consul.live-video.a2z.com:443"
  datacenter = "us-west2"
}

# Write the default region string to each consul datacenter
resource "consul_keys" "default_region_value" {
  for_each   = local.consul_dc_set
  datacenter = each.value

  key {
    path  = "/vidcs/default_region"
    value = join("", transpose(local.full_consul_dc_map)[each.value])
  }
}

# Write the full mapping in each datacenter as well
resource "consul_keys" "full_default_region_mapping" {
  for_each   = local.consul_dc_set
  datacenter = each.value

  key {
    path  = "/vidcs/global_default_region_mapping"
    value = jsonencode(local.full_consul_dc_map)
  }
}
