# IAM

If a machine class has not onboarded yet to milliner IAM roles or needs to retrofit and create more IAM roles per machine class, per datacenter, per environment, this module may be used to create milliner service IAM roles. This will be particularly useful for machine classes with large edge DC footprints, such as ingest-proxy-edge and video-edge.

The module is designed to be flexible for multiple backend service account configurations for bare metal services. The 6 possible variants are:

|Machine Class Milliner Account(s)|Machine Class Location(s) |
|---------------------------------|--------------------------|
|Regional                         |origin service            |
|Regional                         |edge service              |
|Regional                         |both origin and edge      |
|Global                           |origin service            |
|Global                           |edge service              |
|Global                           |both origin and edge      |

## Example usage

- **Version Requirement**: Tested with terraform ~> 0.12.29 (Though any provider >= 0.12.6 should work)

```terraform
module "iam" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-tls-iam.git//iam?ref=v1.0.2"
  machine_class = "ingest"
  environment = "prod"
  location = "origin"
  role_strategy = "regional"
  account_region = "us-west-2"
}
```

The following configuration posits goingest is a origin-homed service and development teams have made AWS accounts per origin region. The `terraform plan` will create roles for PoPs that map back to us-west-2.

```terraform
Terraform will perform the following actions:

  # module.iam.aws_iam_policy.assumerole_source_policy will be created
  + resource "aws_iam_policy" "assumerole_source_policy" {
      + arn         = (known after apply)
      + description = "Allow sts:AssumeRole calls from this IAM-Role to to any other IAM-Role. Destination IAM-Role must still explicitly allow this source IAM-Role to reach it. This allows VidCS to onboard to Milliner by giving them AssumeRole access from a host's IAM-Role to their maintenance IAM-Roles."
      + id          = (known after apply)
      + name        = (known after apply)
      + name_prefix = "VidTools-Generalized-AssumeRole-Source"
      + path        = "/"
      + policy      = jsonencode(
            {
              + Statement = [
                  + {
                      + Action    = "sts:AssumeRole"
                      + Condition = {
                          + StringEquals = {
                              + aws:PrincipalOrgID = "o-pa7on1mit6"
                            }
                        }
                      + Effect    = "Allow"
                      + Resource  = "*"
                      + Sid       = ""
                    },
                ]
              + Version   = "2012-10-17"
            }
        )
    }

  # module.iam.aws_iam_role.milliner_iam_roles["milliner-ingest-prod-pdx05"] will be created
  + resource "aws_iam_role" "milliner_iam_roles" {
      + arn                   = (known after apply)
      + assume_role_policy    = jsonencode(
            {
              + Statement = [
                  + {
                      + Action    = "sts:AssumeRole"
                      + Effect    = "Allow"
                      + Principal = {
                          + AWS = "arn:aws:iam::230552635125:role/MachineRole"
                        }
                      + Sid       = ""
                    },
                ]
              + Version   = "2012-10-17"
            }
        )
      + create_date           = (known after apply)
      + force_detach_policies = false
      + id                    = (known after apply)
      + max_session_duration  = 3600
      + name                  = "milliner-ingest-prod-pdx05"
      + path                  = "/"
      + unique_id             = (known after apply)
    }

  # module.iam.aws_iam_role.milliner_iam_roles["milliner-ingest-prod-sjc02"] will be created
  + resource "aws_iam_role" "milliner_iam_roles" {
      + arn                   = (known after apply)
      + assume_role_policy    = jsonencode(
            {
              + Statement = [
                  + {
                      + Action    = "sts:AssumeRole"
                      + Effect    = "Allow"
                      + Principal = {
                          + AWS = "arn:aws:iam::230552635125:role/MachineRole"
                        }
                      + Sid       = ""
                    },
                ]
              + Version   = "2012-10-17"
            }
        )
      + create_date           = (known after apply)
      + force_detach_policies = false
      + id                    = (known after apply)
      + max_session_duration  = 3600
      + name                  = "milliner-ingest-prod-sjc02"
      + path                  = "/"
      + unique_id             = (known after apply)
    }

  # module.iam.aws_iam_role_policy_attachment.assumerole_source_attachment["milliner-ingest-prod-pdx05"] will be created
  + resource "aws_iam_role_policy_attachment" "assumerole_source_attachment" {
      + id         = (known after apply)
      + policy_arn = (known after apply)
      + role       = "milliner-ingest-prod-pdx05"
    }

  # module.iam.aws_iam_role_policy_attachment.assumerole_source_attachment["milliner-ingest-prod-sjc02"] will be created
  + resource "aws_iam_role_policy_attachment" "assumerole_source_attachment" {
      + id         = (known after apply)
      + policy_arn = (known after apply)
      + role       = "milliner-ingest-prod-sjc02"
    }

Plan: 5 to add, 0 to change, 0 to destroy.
```

If the `account_region` argument was swapped to `eu-west-2`, only the `lhr05` role would be created. If `role strategy` is set to `global` (which means `account_region` may be left unset; it will not be respected if set), it means that all milliner IAM roles for all origin DCS (i.e: `sjc02`, `pdx05`, `cmh01`, `lhr05`) will be created.

## Requirements

No requirements.

## Providers

| Name | Version |
|------|---------|
| aws | n/a |
| null | n/a |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| account\_region | If regional is selected as the role strategy, specify which region this account lives in. This informs which PoP roles will get created. | `any` | `null` | no |
| environment | The environment of your machine class (prod \| staging \| dev) | `any` | n/a | yes |
| location | Where your machine class is homed (edge \| origin \| both). | `any` | n/a | yes |
| machine\_class | The name of your machine class (i.e: role, service). | `any` | n/a | yes |
| role\_strategy | Is your machine class milliner mapped to a single, monolithic account or multiple, regional accounts (global \| regional).<br>If global is selected, it will create all pop roles for all regions at once.<br>If regional is selected, it will create all pop roles mapped to that specific region. | `any` | n/a | yes |

## Outputs

| Name | Description |
|------|-------------|
| milliner\_iam\_role\_arns | A list of milliner IAM role ARNs created by the module. |
| milliner\_iam\_role\_ids | A list of milliner IAM role IDs created by the module. ID and name are the same export value in terraform. |
