# Hacky validation since varible validation not a feature until tf 0.13
resource "null_resource" "validate_environment" {
  count = contains(local.valid_environment, var.environment) == true ? 0 : "Please provide a valid environment. (prod|staging|dev)"
}
resource "null_resource" "validate_location" {
  count = contains(local.valid_location, var.location) == true ? 0 : "Please provide a valid location. (edge|origin|both)"
}
resource "null_resource" "validate_role_strategy" {
  count = contains(local.valid_role_strategy, var.role_strategy) == true ? 0 : "Please provide a valid role strategy. (global|regional)"
}

data "aws_caller_identity" "current" {}

locals {
  pop_list = var.role_strategy == "global" ? toset(module.mapping.global_map[var.location]) : toset(module.mapping.regional_map[var.location][var.account_region])
  // for the ids output
  name_list = [for pop in local.pop_list :
    "milliner-${var.machine_class}-${var.environment}-${pop}"
  ]
  // for the arn output
  arn_list = [for pop in local.pop_list :
    "arn:aws:iam:${data.aws_caller_identity.current.account_id}:role/milliner-${var.machine_class}-${var.environment}-${pop}"
  ]
}

// (1 of 3) instantiate the milliner-principal module
module "milliner_principal" {
  source = "git::ssh://git@git.xarth.tv/terraform-modules/milliner-principal-policy.git"
}

module "mapping" {
  source = "../mapping"
}

// (2 of 3) include the milliner-principal policy in your iam-role's trust-policy
resource "aws_iam_role" "milliner_iam_roles" {
  for_each           = toset(local.name_list)
  name               = each.value
  assume_role_policy = module.milliner_principal.policy_document
}

// Unrolled module from git@git.xarth.tv/terraform-modules/video-organization-principal.git//source
// tf0.13 would allow for module for_each, but we're not there yet.
data "aws_iam_policy_document" "assumerole_source_policy_statement" {
  statement {
    effect    = "Allow"
    actions   = ["sts:AssumeRole"]
    resources = ["*"]
    condition {
      test     = "StringEquals"
      variable = "aws:PrincipalOrgID"
      values   = ["o-pa7on1mit6"] // Video organizational assume-role
    }
  }
}

resource "aws_iam_policy" "assumerole_source_policy" {
  name_prefix = "VidTools-Generalized-AssumeRole-Source"
  policy      = data.aws_iam_policy_document.assumerole_source_policy_statement.json
  description = "Allow sts:AssumeRole calls from this IAM-Role to to any other IAM-Role. Destination IAM-Role must still explicitly allow this source IAM-Role to reach it. This allows VidCS to onboard to Milliner by giving them AssumeRole access from a host's IAM-Role to their maintenance IAM-Roles."
}

resource "aws_iam_role_policy_attachment" "assumerole_source_attachment" {
  for_each   = toset(local.name_list)
  role       = each.value
  policy_arn = aws_iam_policy.assumerole_source_policy.arn
}
