# Mapping

Provides the authoritative mapping for services that have onboarded to the TLS sandstorm solution. It provides basic, structured mappings that can be manipulated flexibly by other modules or non-modules alike. See examples of manipulation in the `iam` and `sandstorm` modules and the `consul` directory.

Intent: downstream modules like milliner-mappings and whatever other terraform infra can grok enough metadata about onboarded services. The mapping module creates no resources and is designed to be idempotent, so it may be declared as many times as needed with whichever argument combination.

## Requirements

No requirements.

## Providers

No provider.

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| account\_region | If regional is selected as the role strategy, specify which region this account lives in. This informs which PoP roles will get created. | `any` | `null` | no |
| location | Where your machine class is homed (edge \| origin \| both). Default: both | `string` | `"both"` | no |
| role\_strategy | Is your machine class milliner mapped to a single, monolithic account or multiple, regional accounts (global \| regional).<br>If global is selected, it will create all pop roles for all regions at once.<br>If regional is selected, it will create all pop roles mapped to that specific region.<br>Default: global | `string` | `"global"` | no |

## Outputs

| Name | Description |
|------|-------------|
| all\_dcs | A map of AWS regions => which bare metal PoP map to that region |
| edge\_dcs | A map of AWS regions => which bare metal edge PoPs map to that region. |
| global\_map | A map of machine class location to a list of PoPs if your service is backed by a global account. |
| origin\_dcs | A map of AWS regions => which bare metal origin PoPs map to that region. |
| regional\_map | A map of machine class location to a map of AWS regions to a list of PoPs if your service is backed by regional accounts.<br>Note that unlike the global\_map, the regional map is nested. e.g: {"edge": {"us-west-2": [...], "us-east-1": [...]}, "both": {"us-west-2": [...]} ...} |
| service\_tls\_mapping | Provides baseline metadata for a machine class so tls related infrastructure can be built. |
