# The mapping TM
locals {
  origin_dcs = {
    "us-west-2"      = ["sjc02", "pdx05"]
    "us-east-1"      = []
    "us-east-2"      = ["cmh01"]
    "eu-west-1"      = []
    "eu-west-2"      = ["lhr05"]
    "ap-southeast-1" = []
  }

  edge_dcs = {
    "us-west-2" = [
      "hou01",
      "lax03",
      "pdx01",
      "phx01",
      "sea01",
      "sjc05",
      "slc01",
      "syd01",
    ]

    "us-east-1" = [
      "atl01",
      "dfw02",
      "iad03",
      "iad05",
      "jfk04",
      "jfk06",
      "mia02",
      "qro01",
      "rio01",
      "sao01",
    ]

    "us-east-2" = [
      "den01",
      "ord02",
      "ord03",
      "ymq01",
      "yto01",
    ]

    "eu-west-1" = [
      "ams02",
      "ams03",
      "arn03",
      "ber01",
      "cdg02",
      "cph01",
      "fra02",
      "fra05",
      "fra06",
      "hel01",
      "lhr03",
      "lhr04",
      "mad01",
      "mil01",
      "mrs01",
      "osl01",
      "prg02",
      "vie01",
      "waw01",
    ]

    "eu-west-2" = []

    "ap-southeast-1" = [
      "bkk01",
      "hkg01",
      "sel01",
      "sel03",
      "sin01",
      "tpe01",
      "tpe03",
      "tyo01",
    ]
  }
}

locals {
  map_selection_global = {
    "origin" = flatten(values(local.origin_dcs))
    "edge"   = flatten(values(local.edge_dcs))
    "both"   = flatten([values(local.origin_dcs), values(local.edge_dcs)])
  }

  map_selection_regional = {
    "origin" = local.origin_dcs
    "edge"   = local.edge_dcs
    "both"   = { for r, dcs in local.edge_dcs : r => flatten([local.origin_dcs[r], dcs]) }
  }
}



# XXX TO BE USED IN tf 0.11. The simplified mapping above is used for >= tf 0.12.
// 
// # Hacky validation since varible validation not a feature until tf 0.13
// resource "null_resource" "validate_location" {
//   count = contains(local.valid_location, var.location) == true ? 0 : "Please provide a valid location. (edge|origin|both)"
// }
// resource "null_resource" "validate_role_strategy" {
//   count = contains(local.valid_role_strategy, var.role_strategy) == true ? 0 : "Please provide a valid role strategy. (global|regional)"
// }
// # Role variation creation spread
// # The purpose of the evaluation is to support the variety of services development teams own in our infra today.
// # Machine classes may live in only an origin or an edge pop or both, and their milliner service accounts may be a
// # monolithic account or they may have followed guidance to make bound region accounts.
// # The variations are listed below:
// #     <ACCOUNT(s)>, <type of service>
// #    1. Regional,   origin service
// #    2. Regional,   edge service
// #    3. Regional,   both origin and edge
// #    4. Global,     origin service
// #    5. Global,     edge service
// #    6. Global,     both origin and edge 
// locals {
//   # Depending on the service account strategy, we either want to include all pops that map to that region, or just all pops
//   edge_select_strategy = var.role_strategy == "regional" ? local.edge_dcs[var.account_region] : flatten([values(local.edge_dcs)])
//   # If the service is not homed in any edge PoP, leave the list empty. Otherwise, grok the whole list 
//   edge_select_location = var.location == "origin" ? [] : flatten(values(local.edge_dcs))
//   # The final list of edge_dcs to consider is the intersection of both lists above
//   edge_list = setintersection(local.edge_select_location, local.edge_select_strategy)
// 
//   # Similar logic above but for origins instead of edge pops
//   origin_select_strategy = var.role_strategy == "regional" ? local.origin_dcs[var.account_region] : flatten([values(local.origin_dcs)])
//   origin_select_location = var.location == "edge" ? [] : flatten(values(local.origin_dcs))
//   origin_list            = setintersection(local.origin_select_strategy, local.origin_select_location)
// }
