output "origin_dcs" {
  description = "A map of AWS regions => which bare metal origin PoPs map to that region."
  value       = local.origin_dcs
}

output "edge_dcs" {
  description = "A map of AWS regions => which bare metal edge PoPs map to that region."
  value       = local.edge_dcs
}

output "all_dcs" {
  description = "A map of AWS regions => which bare metal PoP map to that region"
  value       = { for r, dcs in local.edge_dcs : r => flatten([dcs, local.origin_dcs[r]]) }
}

output "global_map" {
  description = "A map of machine class location to a list of PoPs if your service is backed by a global account."
  value       = local.map_selection_global
}

output "regional_map" {
  description = <<EOF
A map of machine class location to a map of AWS regions to a list of PoPs if your service is backed by regional accounts.
Note that unlike the global_map, the regional map is nested. e.g: {"edge": {"us-west-2": [...], "us-east-1": [...]}, "both": {"us-west-2": [...]} ...}
EOF
  value       = local.map_selection_regional
}

# For the account mapping: Values could be just full ARNs and logic could be kerfuffled into consumers
# either grokking the substring "arn"
output "service_tls_mapping" {
  description = "Provides baseline metadata for a machine class so tls related infrastructure can be built."
  value = {
    # VIDCS-XXXX video-ingestorigin
    ingest = {
      role_strategy = "regional"
      location      = "origin"
      account_mapping = {
        prod = {
          us-west-2 = "973062355145" # aws-sf-video-ingest+goingest-prod-us-west-2-sjc
          us-east-2 = "597239195583" # aws-sf-video-ingest+goingest-prod-us-east-2-lhr
          eu-west-2 = "022246982016" # aws-sf-video-ingest+goingest-prod-eu-west-2-lhr
        }
        staging = {
          us-west-2 = "752545228058" # aws-sf-video-ingest+goingest-staging-us-west-2-sjc
          us-east-2 = "302362751906" # aws-sf-video-ingest+goingest-staging-us-east-2-cmh
          eu-west-2 = "575411533089" # aws-sf-video-ingest+goingest-staging-eu-west-2-lhr
        }
        dev = {} #Define even if undefined
      }
    }
    # more machine class mappings..
  }
}



# XXX TO BE USED IN TF 0.11 instead of regional_map and global_map (< 0.12 lacks for loops).
// output "pop_list" {
//   description = <<EOF
// Given the inputs location, role_strategy, and account region, emit a list of PoPs that map to your service.
// For example, if you have an origin service with regional service accounts, 
// and you're running terraform for the us-west-2 instance of your service, the pop_list would emit ["pdx05", "sjc02"].
// If you had the same origin service but centralized your service account, the pop_list would emit all origin pops
// ["pdx05", "sjc02", "cmh01", "lhr05"].
// EOF
//   value       = toset(flatten([local.edge_list, local.origin_list])) #flattening of two lists above determines the iam roles to create
// }
