variable "location" {
  description = "Where your machine class is homed (edge | origin | both). Default: both"
  default     = "both"
}

variable "role_strategy" {
  description = <<EOF
Is your machine class milliner mapped to a single, monolithic account or multiple, regional accounts (global | regional).
If global is selected, it will create all pop roles for all regions at once.
If regional is selected, it will create all pop roles mapped to that specific region.
Default: global
EOF
  default     = "global"
}

variable "account_region" {
  description = "If regional is selected as the role strategy, specify which region this account lives in. This informs which PoP roles will get created."
  default     = null
}

locals {
  valid_environment   = ["prod", "staging", "dev"]
  valid_location      = ["edge", "origin", "both"]
  valid_role_strategy = ["global", "regional"]
}
