variable "region" {
  description = "AWS region"
  default     = "us-west-2"
}

variable "account_mapping" {
  type        = map
  description = "Account mapping where key is an environment and the value is a map that maps a region to account number"
}

variable "machine_class" {
  description = "Name of the machine class you are onboarding"
}

variable "location" {
  description = "Where your machine class is homed (edge | origin | both)."
}

variable "account_region" {
  description = "If regional is selected as the role strategy, specify which region this account lives in. This informs which PoP roles will get created."
  default     = null
}
