#!/usr/bin/env python

import os
import shutil
import time

PUPPET_ENVIRONMENT_DIR = "/mnt/efs/"
EXPIRATION_SECONDS = 1 * 24 * 3600 # 24 * 3600 - seconds per day

def handler(event, context):
    now = time.time()
    for f in os.listdir(PUPPET_ENVIRONMENT_DIR):
        path = os.path.join(PUPPET_ENVIRONMENT_DIR, f)
        print(f"Found {path}")
        if os.stat(path).st_mtime > now - EXPIRATION_SECONDS:
            continue
        print(f"Deleting {path}")
        if os.path.isfile(path) or os.path.islink(path):
            os.unlink(path)
        else:
            shutil.rmtree(path)
