resource "aws_efs_file_system" "puppet_environment_renderer_efs" {
  encrypted = true
}

resource "aws_efs_mount_target" "efs_mounts" {
  for_each        = toset(var.subnet_ids)
  file_system_id  = aws_efs_file_system.puppet_environment_renderer_efs.id
  subnet_id       = each.value
  security_groups = var.security_group_ids
}

# EFS access point used by lambda file system
resource "aws_efs_access_point" "access_point_for_lambda" {
  file_system_id = aws_efs_file_system.puppet_environment_renderer_efs.id

  root_directory {
    path = "/lambda"
    creation_info {
      owner_gid   = 1000
      owner_uid   = 1000
      permissions = "777"
    }
  }

  posix_user {
    gid = 1000
    uid = 1000
  }
}
