#!/usr/bin/env python

import boto3
from io import BytesIO
import tarfile
import os
import shutil
import urllib.parse

def get_s3_data(event):
    records = event.get("Records")
    if not records:
        print(event)
        raise Exception('Event data has no "Records" entry')
    s3 = records[0].get("s3")
    if not s3:
        print(event)
        raise Exception('Record data has no "s3" entry')
    return s3

def handler(event, context):
    aws_account_id = context.invoked_function_arn.split(":")[4]
    s3_data = get_s3_data(event)
    bucket_name = urllib.parse.unquote(s3_data.get("bucket", {}).get("name"))
    if not bucket_name:
        print(s3_data)
        raise Exception('Failed to retrieve "bucket_name"')
    object_key = urllib.parse.unquote(s3_data.get("object", {}).get("key"))
    if not object_key:
        print(s3_data)
        raise Exception('Failed to retrieve "object_key"')
    aws_account_id = context.invoked_function_arn.split(":")[4]
    queue_url = f"https://us-west-2.queue.amazonaws.com/{aws_account_id}/{object_key[:-4].replace(':', '_')}"
    s3 = boto3.client('s3', use_ssl=False)
    fileobj = BytesIO(s3.get_object(Bucket=bucket_name, Key=object_key)['Body'].read())
    os.chdir("/mnt/efs/")
    with tarfile.open(fileobj=fileobj, mode="r|gz") as tar:
        tar.extractall()
    sqs = boto3.client('sqs')
    sqs.send_message(
        QueueUrl=queue_url,
        MessageBody=f'status=ok\nobject_key={object_key}'
    )
