# tf-mod-sns-subscription
Creates a SNS topic and SNS topic subscription for vidcs all hours and business hours.


## Usage

```
module "puppet_sns_topic" {
  source       = "git@git.xarth.tv:video-coreservices/tf-mod-sns-subscription?ref=v1.0.1"
  service_name = var.service
}
```

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >=0.12.20 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | n/a |

## Modules

No modules.

## Resources

| Name | Type |
|------|------|
| [aws_sns_topic.all_hours_alarm](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/sns_topic) | resource |
| [aws_sns_topic.business_hours_alarm](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/sns_topic) | resource |
| [aws_sns_topic_subscription.all_hours_pd_subscription](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/sns_topic_subscription) | resource |
| [aws_sns_topic_subscription.business_hours_pd_subscription](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/sns_topic_subscription) | resource |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_service_name"></a> [service\_name](#input\_service\_name) | Name of the service. Must be unique if multiple declarations are instantiated for one region in an account. | `string` | n/a | yes |

## Outputs

| Name | Description |
|------|-------------|
| <a name="output_all_hours_topic_arn"></a> [all\_hours\_topic\_arn](#output\_all\_hours\_topic\_arn) | The ARN of the all hours SNS topic |
| <a name="output_business_hours_topic_arn"></a> [business\_hours\_topic\_arn](#output\_business\_hours\_topic\_arn) | The ARN of the business hours only SNS topic |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
