resource "aws_sns_topic" "all_hours_alarm" {
  name_prefix = "${var.service_name}-all-hours-alarm"
}

resource "aws_sns_topic_subscription" "all_hours_pd_subscription" {
  topic_arn              = aws_sns_topic.all_hours_alarm.arn
  protocol               = "https"
  endpoint               = "https://events.pagerduty.com/integration/40834d4b44754cb7a3d65da93914e85a/enqueue"
  endpoint_auto_confirms = true
}

resource "aws_sns_topic" "business_hours_alarm" {
  name_prefix = "${var.service_name}-business-hours-alarm"
}

resource "aws_sns_topic_subscription" "business_hours_pd_subscription" {
  topic_arn              = aws_sns_topic.business_hours_alarm.arn
  protocol               = "https"
  endpoint               = "https://events.pagerduty.com/integration/fb79deea275748acb67a80c0b88c7a7d/enqueue"
  endpoint_auto_confirms = true
}
