# StatsD / Graphite Infrastructure Terraform Module

This module deploys a statsd + graphite stack.

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Usage](#usage)
  - [Example code](#example-code)
  - [Example output](#example-output)
- [Dependencies](#dependencies)
- [Terraform inputs](#terraform-inputs)
  - [Requirements](#requirements)
  - [Providers](#providers)
  - [Modules](#modules)
  - [Resources](#resources)
  - [Inputs](#inputs)
  - [Outputs](#outputs)
- [Development](#development)
  - [Known Issues](#known-issues)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Usage

Use the latest [release](./releases) of this module to setup the infrastructure. Refer to [video-coreservices/tf-io-statsd-graphite](https://git.xarth.tv/video-coreservices/tf-io-statsd-graphite) for an example of how Video CoreServices is deploying this infrastructure in our account.

Refer to this [quickstart guide](https://wiki.xarth.tv/display/VID/Self-hosted+metrics+infrastructure+quick+start) on what is required to setup a functioning infrastructure.

```terraform
module "statsd_graphite" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-statsd-graphite?ref=v1.1.1"

  ...
}
```

### Example code

The following is the bare minimum required to spin up the infrastructure. Refer to terraform inputs below on other supported terraform inputs.

```terraform
module "statsd_graphite" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-statsd-graphite?ref=v1.1.1"

  owner = "<myteam>@twitch.tv"
  team  = "<myteam_name>"

  pagerduty_url = "https//pagerduty/cloudwatch/integration/url"

  vpc_id          = "<vpc_id>"
  subnets         = ["subnet1", "subnet2", "subnet3"]
  security_groups = ["security_group1"]

  go_carbon_cluster_size = <size cluster accordingly>
}

output "stack" {
  value = module.statsd_graphite
}

```

### Example output

```terraform
stack = {
  carbon_c_relay_lb = "carbon-c-relay-a425c80a7fedbf72.elb.us-west-2.amazonaws.com"
  graphite_web_private_dns_name = "graphite-vidcs.live-video.a2z.com"
  graphite_web_vpce_service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-0fb734a9b12187080"
  statsd_lb = "statsd-proxy-6b91fc2f7550d6e0.elb.us-west-2.amazonaws.com:8125"
  zone = {
    "zone" = {
      "id" = "Z09265843B3TDB78UADT"
      "name" = "graphite-vidcs.live-video.a2z.com"
      "name_servers" = tolist([
        "ns-1116.awsdns-11.org",
        "ns-1777.awsdns-30.co.uk",
        "ns-502.awsdns-62.com",
        "ns-714.awsdns-25.net",
      ])
    }
  }
}
```

## Dependencies

This infrastucture works in conjunction with the following repos - which builds the respective component containers. Note that this current terraform module setups the appropriate ECRs and jenkins permissions which will allow the following repositories to build and upload the images to ECR.

* [statsd-proxy](https://git.xarth.tv/video-coreservices/go-statsd-proxy)
* [voncount aka statsite](https://git.xarth.tv/video-coreservices/voncount)
* [carbon-c-relay](https://git.xarth.tv/video-coreservices/carbon-c-relay-container-build)
* [go-carbon](https://git.xarth.tv/video-coreservices/go-carbon-container-build)
* [graphite-web](https://git.xarth.tv/video-coreservices/graphite-web-container-build)

In addition, this module also setups the following for grafana.xarth.tv to work:

* the necessary permissions for grafana.xarth.tv to add Cloudwatch as a datasource
* A VPCe service endpoint where grafana.xarth.tv account is connect to the graphite-web VPCe, allowing grafana to add graphite as a datasource.

## Terraform inputs
<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
### Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >=0.14.7 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | >= 3.37.0 |

### Providers

No providers.

### Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_grafana_cloudwatch_read_only"></a> [grafana\_cloudwatch\_read\_only](#module\_grafana\_cloudwatch\_read\_only) | git@git.xarth.tv:twitch/grafana_datasource.git?ref=v1.1.3 |  |
| <a name="module_graphite"></a> [graphite](#module\_graphite) | git@git.xarth.tv:video-coreservices/tf-mod-graphite-stack?ref=v1.1.1 |  |
| <a name="module_statsd"></a> [statsd](#module\_statsd) | git@git.xarth.tv:video-coreservices/tf-mod-voncount?ref=v1.0.0 |  |

### Resources

No resources.

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_carbon_c_relay_cluster_size"></a> [carbon\_c\_relay\_cluster\_size](#input\_carbon\_c\_relay\_cluster\_size) | The desired cluster size for carbon-c-relay | `number` | `8` | no |
| <a name="input_carbon_c_relay_image_tag"></a> [carbon\_c\_relay\_image\_tag](#input\_carbon\_c\_relay\_image\_tag) | The image hash/tag that will be used to run carbon-c-relay | `string` | `"v3.7.2"` | no |
| <a name="input_env"></a> [env](#input\_env) | The stack environment. One of dev, staging, or prod | `string` | `"prod"` | no |
| <a name="input_go_carbon_cluster_size"></a> [go\_carbon\_cluster\_size](#input\_go\_carbon\_cluster\_size) | ATTENTION: this should be a fixed size, and not be changed after the cluster has been provisioned. Size cluster accordingly.<br>  The desired cluster size for each go-carbon cluster replica. I.e. The total number of instances deployed will double this number provided." | `number` | n/a | yes |
| <a name="input_go_carbon_image_tag"></a> [go\_carbon\_image\_tag](#input\_go\_carbon\_image\_tag) | The image hash/tag that will be used to run go\_carbon | `string` | `"v0.15.6"` | no |
| <a name="input_graphite_web_cluster_size"></a> [graphite\_web\_cluster\_size](#input\_graphite\_web\_cluster\_size) | The desired cluster size for statsd-proxy | `number` | `2` | no |
| <a name="input_graphite_web_image_tag"></a> [graphite\_web\_image\_tag](#input\_graphite\_web\_image\_tag) | The image hash/tag that will be used to run graphite-web | `string` | `"1ca8e602c15ba9ed7737976d01c9d1ba10eafa40"` | no |
| <a name="input_owner"></a> [owner](#input\_owner) | The email address of the owner of this account. E.g. (video-coreservices@twitch.tv) | `string` | n/a | yes |
| <a name="input_pagerduty_url"></a> [pagerduty\_url](#input\_pagerduty\_url) | The pagerduty cloudwatch integration URL used to alert teams of issues | `string` | n/a | yes |
| <a name="input_region"></a> [region](#input\_region) | The AWS region to deploy this stack to | `string` | `"us-west-2"` | no |
| <a name="input_security_groups"></a> [security\_groups](#input\_security\_groups) | The security groups to associate this stack to. Ensure that this security group permits traffic from sources that will be sending traffic to this cluster. Typically twitch subnets. | `list(string)` | n/a | yes |
| <a name="input_statsd_cluster_size"></a> [statsd\_cluster\_size](#input\_statsd\_cluster\_size) | The desired cluster size for statsd (statsite) | `number` | `12` | no |
| <a name="input_statsd_proxy_cluster_size"></a> [statsd\_proxy\_cluster\_size](#input\_statsd\_proxy\_cluster\_size) | The desired cluster size for statsd-proxy | `number` | `9` | no |
| <a name="input_statsd_proxy_image_tag"></a> [statsd\_proxy\_image\_tag](#input\_statsd\_proxy\_image\_tag) | The image hash/tag that will be used to run statsd-proxy | `string` | `"bootstrap"` | no |
| <a name="input_statsite_image_tag"></a> [statsite\_image\_tag](#input\_statsite\_image\_tag) | The image hash/tag that will be used to run statsite | `string` | `"8dd7750dbecee9ca5fa29469d9e223cbbcf687c3"` | no |
| <a name="input_subnets"></a> [subnets](#input\_subnets) | The subnets to deploy this stack to | `list(string)` | n/a | yes |
| <a name="input_team"></a> [team](#input\_team) | The name of the team owning this infrastructure. Name should all be lowercased, words separated by dash (-). (E.g. vidcs) | `string` | n/a | yes |
| <a name="input_vpc_id"></a> [vpc\_id](#input\_vpc\_id) | The VPC to deploy this stack to | `string` | n/a | yes |
| <a name="input_vpce_allowed_principals"></a> [vpce\_allowed\_principals](#input\_vpce\_allowed\_principals) | A list of trusted accounts for the graphite-web VPCe. Defaults to aws-infra prod and dev grafana accounts | `list(any)` | <pre>[<br>  "arn:aws:iam::109561199089:root",<br>  "arn:aws:iam::963768028156:root"<br>]</pre> | no |

### Outputs

| Name | Description |
|------|-------------|
| <a name="output_carbon_c_relay_lb"></a> [carbon\_c\_relay\_lb](#output\_carbon\_c\_relay\_lb) | The graphite endpoint for sending graphite metrics |
| <a name="output_graphite_web_private_dns_name"></a> [graphite\_web\_private\_dns\_name](#output\_graphite\_web\_private\_dns\_name) | The private dns name associated with the graphite-web VPCe service |
| <a name="output_graphite_web_vpce_service_name"></a> [graphite\_web\_vpce\_service\_name](#output\_graphite\_web\_vpce\_service\_name) | The graphite-web VPCe service to be privatelink to other accounts |
| <a name="output_statsd_lb"></a> [statsd\_lb](#output\_statsd\_lb) | The statsd endpoint for sending metrics to |
| <a name="output_zone"></a> [zone](#output\_zone) | DNS zone delegation information required by VidCS |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.

### Known Issues

You may encounter the following issues when `terraform validate` part of the `pre-commit` hook is executed:

* `terraform` AWS provider requires a region to be set when `terraform validate` is being performed. If a region not set related error is prompted, set `export AWS_REGION=us-west-2` in your current terminal session.
