# Voncount provides statsdproxy + statsd (statsite)
module "statsd" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-voncount?ref=v1.0.0"

  region = var.region

  vpc_id          = var.vpc_id
  subnets         = var.subnets
  security_groups = var.security_groups

  owner = var.owner
  team  = var.team

  env = var.env

  statsd_proxy_image_tag = var.statsd_proxy_image_tag
  statsite_image_tag     = var.statsite_image_tag

  statsd_proxy_asg_instances = var.statsd_proxy_cluster_size
  statsite_cluster_size      = var.statsd_cluster_size

  graphite_url = module.graphite.carbon_c_relay_lb

  pagerduty_sns_topic_arns = [module.graphite.pagerduty_sns_topic_arn]
}

# Self hosted graphite infrastructure
module "graphite" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-graphite-stack?ref=v1.1.1"

  region = var.region

  vpc_id           = var.vpc_id
  graphite_subnets = var.subnets
  security_groups  = var.security_groups

  owner     = var.owner
  team_name = var.team

  env = var.env

  go_carbon_image_tag      = var.go_carbon_image_tag
  graphite_web_image_tag   = var.graphite_web_image_tag
  carbon_c_relay_image_tag = var.carbon_c_relay_image_tag

  go_carbon_node_count      = var.go_carbon_cluster_size
  graphite_web_node_count   = var.graphite_web_cluster_size
  carbon_c_relay_node_count = var.carbon_c_relay_cluster_size

  pagerduty_url = var.pagerduty_url

  vpce_allowed_principals = var.vpce_allowed_principals
}
