<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**  *generated with [DocToc](https://github.com/thlorenz/doctoc)*

- [VPC Creation Base](#vpc-creation-base)
  - [Requirements](#requirements)
  - [Providers](#providers)
  - [Modules](#modules)
  - [Resources](#resources)
  - [Inputs](#inputs)
  - [Outputs](#outputs)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# VPC Creation Base

This module wraps and versions the base [AWS VPC Terraform module](https://registry.terraform.io/modules/terraform-aws-modules/vpc/aws). This ensures best practice resource creation, preset with sane defaults for Twitch IVS "tiny bubbles" account.

Under the hood it also uses [Terraform CIDR Subnets Module](https://registry.terraform.io/modules/hashicorp/subnets/cidr) to consistently generate CIDR subnets for each AZ in each Region. This allows the module to non-destructively grow into more AZs if they become available.

Subnets are calculated by this logic:

    for each AZ create a private subnet and public subnet

This yields something like this with a single AZ given:

```
    private_subnets = [
        "172.14.1.0/24",
    ]
    public_subnets  = [
        "172.14.0.0/24",
    ]
```
When you later add another:

```
    private_subnets = [
        "172.14.1.0/24",
      + "172.14.3.0/24",
    ]
    public_subnets  = [
        "172.14.0.0/24",
      + "172.14.2.0/24",
    ]
```
Grow to all:

```
    private_subnets = [
        "172.14.1.0/24",
      + "172.14.3.0/24",
      + "172.14.5.0/24",
      + "172.14.7.0/24",
    ]
    public_subnets = [
        "172.14.0.0/24",
      + "172.14.2.0/24",
      + "172.14.4.0/24",
      + "172.14.6.0/24",
    ]
```

<!-- BEGIN_TF_DOCS -->
## Requirements

No requirements.

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | n/a |

## Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_subnet_addrs"></a> [subnet\_addrs](#module\_subnet\_addrs) | hashicorp/subnets/cidr | 1.0.0 |
| <a name="module_vpc"></a> [vpc](#module\_vpc) | git::ssh://git@git.xarth.tv/terraform-modules/terraform-aws-vpc.git | v3.2.0 |

## Resources

| Name | Type |
|------|------|
| [aws_availability_zones.all](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/availability_zones) | data source |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_availability_zones"></a> [availability\_zones](#input\_availability\_zones) | Availability Zones to use. If not given, will auto-detect from used region and use all of them | `list(any)` | `[]` | no |
| <a name="input_base_cidr_block"></a> [base\_cidr\_block](#input\_base\_cidr\_block) | The base CIDR block to assign to the VPC. Subnets are calculated from this automatically by adding 4 bits | `string` | `"172.16.0.0/16"` | no |
| <a name="input_default_security_group_egress"></a> [default\_security\_group\_egress](#input\_default\_security\_group\_egress) | Default SG Egress rules | `list(map(string))` | <pre>[<br>  {<br>    "cidr_blocks": "0.0.0.0/0",<br>    "from_port": 0,<br>    "protocol": "-1",<br>    "to_port": 0<br>  }<br>]</pre> | no |
| <a name="input_default_security_group_ingress"></a> [default\_security\_group\_ingress](#input\_default\_security\_group\_ingress) | Default SG Ingress rules | `list(map(string))` | <pre>[<br>  {<br>    "from_port": 0,<br>    "protocol": "-1",<br>    "self": true,<br>    "to_port": 0<br>  }<br>]</pre> | no |
| <a name="input_internet_access"></a> [internet\_access](#input\_internet\_access) | Whether or not the VPC created should also create needed internet accessible subnets and IGW and NGWs. Perhaps if your Lambda only needs to access AWS or VPCe resources would this be useful | `bool` | `true` | no |
| <a name="input_manage_default_route_table"></a> [manage\_default\_route\_table](#input\_manage\_default\_route\_table) | Should be true to manage default route table | `bool` | `false` | no |
| <a name="input_manage_default_security_group"></a> [manage\_default\_security\_group](#input\_manage\_default\_security\_group) | Should be true to adopt and manage default security group | `bool` | `true` | no |
| <a name="input_service_name"></a> [service\_name](#input\_service\_name) | The service name to use. Mainly used in labeling the default Name tag | `string` | n/a | yes |
| <a name="input_tags"></a> [tags](#input\_tags) | A map of tags given to any resource created that supports tags | `map(string)` | `{}` | no |

## Outputs

| Name | Description |
|------|-------------|
| <a name="output_intra_route_table_ids"></a> [intra\_route\_table\_ids](#output\_intra\_route\_table\_ids) | List of IDs of intra route tables |
| <a name="output_intra_subnet_ids"></a> [intra\_subnet\_ids](#output\_intra\_subnet\_ids) | List of IDs of private subnets |
| <a name="output_main_route_table_id"></a> [main\_route\_table\_id](#output\_main\_route\_table\_id) | The ID of the main route table associated with this VPC |
| <a name="output_private_route_table_ids"></a> [private\_route\_table\_ids](#output\_private\_route\_table\_ids) | List of IDs of private route tables |
| <a name="output_private_subnet_ids"></a> [private\_subnet\_ids](#output\_private\_subnet\_ids) | List of IDs of private subnets |
| <a name="output_private_subnets"></a> [private\_subnets](#output\_private\_subnets) | A list of private subnets created by this module. |
| <a name="output_public_route_table_ids"></a> [public\_route\_table\_ids](#output\_public\_route\_table\_ids) | List of IDs of public route tables |
| <a name="output_public_subnet_ids"></a> [public\_subnet\_ids](#output\_public\_subnet\_ids) | List of IDs of public subnets |
| <a name="output_public_subnets"></a> [public\_subnets](#output\_public\_subnets) | A list of public subnets created by this module. |
| <a name="output_vpc_default_security_group_id"></a> [vpc\_default\_security\_group\_id](#output\_vpc\_default\_security\_group\_id) | The ID of the default security group of the VPC created by this module. |
| <a name="output_vpc_id"></a> [vpc\_id](#output\_vpc\_id) | The ID of the VPC created by this module. |
<!-- END_TF_DOCS -->
