module "vpc" {
  source = "./.."

  service_name = "package-repo"

  base_cidr_block    = "172.14.0.0/20"
  availability_zones = ["us-west-2a", "us-west-2b"]

  tags = {
    Environment = "dev"
    OtherTag    = "something"
    Owner       = "kmullin"
  }
}

provider "aws" {
  region = "us-west-2"
}

output "public" {
  value = module.vpc.public_subnets
}

output "private" {
  value = module.vpc.private_subnets
}
