# Grab all AZ that are not Local Zones
data "aws_availability_zones" "all" {
  filter {
    name   = "opt-in-status"
    values = ["opt-in-not-required"]
  }
}

locals {
  azs     = length(var.availability_zones) == 0 ? data.aws_availability_zones.all.names : var.availability_zones
  num_azs = length(local.azs)

  az_net_list = setproduct(local.azs, ["public", "private"])

  networks = [for i, n in local.az_net_list : {
    name     = join("-", n)
    new_bits = 4
  }]

  public_subnets  = [for k, v in module.subnet_addrs.network_cidr_blocks : v if trimsuffix(k, "public") != k]
  private_subnets = [for k, v in module.subnet_addrs.network_cidr_blocks : v if trimsuffix(k, "private") != k]
}

module "subnet_addrs" {
  source  = "hashicorp/subnets/cidr"
  version = "1.0.0"

  base_cidr_block = var.base_cidr_block
  networks        = local.networks
}

module "vpc" {
  source = "git::ssh://git@git.xarth.tv/terraform-modules/terraform-aws-vpc.git?ref=v3.2.0"

  name            = var.service_name
  cidr            = var.base_cidr_block
  azs             = local.azs
  public_subnets  = var.internet_access ? local.public_subnets : []
  private_subnets = var.internet_access ? local.private_subnets : []
  intra_subnets   = var.internet_access ? [] : local.private_subnets

  enable_dns_hostnames = true
  enable_dns_support   = true

  enable_nat_gateway     = var.internet_access
  single_nat_gateway     = false
  one_nat_gateway_per_az = true

  manage_default_security_group = var.manage_default_security_group
  manage_default_route_table    = var.manage_default_route_table

  default_security_group_ingress = var.default_security_group_ingress
  default_security_group_egress  = var.default_security_group_egress

  public_subnet_suffix  = "public"
  private_subnet_suffix = "private"
  intra_subnet_suffix   = "intra"

  tags = var.tags
}
