output "vpc_id" {
  description = "The ID of the VPC created by this module."
  value       = module.vpc.vpc_id
}

output "vpc_default_security_group_id" {
  description = "The ID of the default security group of the VPC created by this module."
  value       = module.vpc.default_security_group_id
}

output "public_route_table_ids" {
  description = "List of IDs of public route tables"
  value       = module.vpc.public_route_table_ids
}

output "private_route_table_ids" {
  description = "List of IDs of private route tables"
  value       = module.vpc.private_route_table_ids
}

output "intra_route_table_ids" {
  description = "List of IDs of intra route tables"
  value       = module.vpc.intra_route_table_ids
}

output "public_subnets" {
  description = "A list of public subnets created by this module."
  value       = local.public_subnets
}

output "private_subnets" {
  description = "A list of private subnets created by this module."
  value       = local.private_subnets
}

output "main_route_table_id" {
  description = "The ID of the main route table associated with this VPC"
  value       = module.vpc.vpc_main_route_table_id
}

output "public_subnet_ids" {
  description = "List of IDs of public subnets"
  value       = module.vpc.public_subnets
}

output "private_subnet_ids" {
  description = "List of IDs of private subnets"
  value       = module.vpc.private_subnets
}

output "intra_subnet_ids" {
  description = "List of IDs of private subnets"
  value       = module.vpc.intra_subnets
}
