variable "tags" {
  type        = map(string)
  default     = {}
  description = "A map of tags given to any resource created that supports tags"
}

variable "service_name" {
  type        = string
  description = "The service name to use. Mainly used in labeling the default Name tag"
}

variable "internet_access" {
  type        = bool
  default     = true
  description = "Whether or not the VPC created should also create needed internet accessible subnets and IGW and NGWs. Perhaps if your Lambda only needs to access AWS or VPCe resources would this be useful"
}

variable "base_cidr_block" {
  type        = string
  default     = "172.16.0.0/16"
  description = "The base CIDR block to assign to the VPC. Subnets are calculated from this automatically by adding 4 bits"
}

variable "availability_zones" {
  type        = list(any)
  default     = []
  description = "Availability Zones to use. If not given, will auto-detect from used region and use all of them"
}

variable "manage_default_security_group" {
  type        = bool
  default     = true
  description = "Should be true to adopt and manage default security group"
}

variable "manage_default_route_table" {
  type        = bool
  default     = false
  description = "Should be true to manage default route table"
}

variable "default_security_group_ingress" {
  type = list(map(string))
  default = [
    {
      protocol  = "-1"
      self      = true
      from_port = 0
      to_port   = 0
    },
  ]
  description = "Default SG Ingress rules"
}

variable "default_security_group_egress" {
  type = list(map(string))
  default = [
    {
      from_port   = 0
      to_port     = 0
      protocol    = "-1"
      cidr_blocks = "0.0.0.0/0"
    },
  ]
  description = "Default SG Egress rules"
}
