# Video CoreServices Voncount Deployment

This provides voncount cluster module that the Edge team has built to support sending metrics to a graphite backend. Note that most of the subcomponents has been forked into `video-coreservices` org. This particular module expects sending metrics to a self hosted graphite backend today.

Container repos:

* [vouncount](https://git.xarth.tv/video-coreservices/voncount)
* [go-statsd-proxy](https://git.xarth.tv/video-coreservices/go-statsd-proxy)

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**

- [Components](#components)
- [Requirements](#requirements)
- [Self Hosted Graphite](#self-hosted-graphite)
- [Terraform inputs](#terraform-inputs)
  - [Requirements](#requirements-1)
  - [Providers](#providers)
  - [Modules](#modules)
  - [Resources](#resources)
  - [Inputs](#inputs)
  - [Outputs](#outputs)
- [Development](#development)
  - [Known Issues](#known-issues)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Components

Voncount is a tiered solution for scalability and has two main components:

 1. [**go-statsd-proxy**](https://git.xarth.tv/video-coreservices/go-statsd-proxy) takes udp metrics requests in the statsd format and distributes them across a consistent hashing pool of statsd instances

 1. [**statsite**](https://git.xarth.tv/video-coreservices/voncount/blob/master/docs/statsite.md) is a high-throughput statsd replacement that aggregates sharded statistics.

    * [**Plumbago**](https://git.xarth.tv/edge/plumbago) is a replacement emitter for graphite stats with better throughput and observability.

![Architecture Diagram](docs/architecture.svg)

## Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)

## Self Hosted Graphite

The latest iteration assumes sending metrics directly to a self hosted graphite cluster. Metricfire and Grafana Cloud are now not supported.

## Terraform inputs

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
### Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >=0.14.7 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | >= 3.7.0 |
| <a name="requirement_template"></a> [template](#requirement\_template) | >= 2.1 |

### Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | >= 3.7.0 |

### Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_core_account"></a> [core\_account](#module\_core\_account) | git::git+ssh://git@git.xarth.tv/video-coreservices/tf-mod-voncount-core-account?ref=v1.1.0 |  |
| <a name="module_jenkins"></a> [jenkins](#module\_jenkins) | git@git.xarth.tv:video-coreservices/tf-mod-jenkins-role.git?ref=v1.0.1 |  |
| <a name="module_statsd_proxy"></a> [statsd\_proxy](#module\_statsd\_proxy) | git@git.xarth.tv:video-coreservices/go-statsd-proxy.git//terraform?ref=v0.5.3 |  |
| <a name="module_statsite"></a> [statsite](#module\_statsite) | ./modules/statsite |  |

### Resources

| Name | Type |
|------|------|
| [aws_cloudwatch_log_group.statsite](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/cloudwatch_log_group) | resource |
| [aws_ecr_lifecycle_policy.statsite_lifecycle_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/ecr_lifecycle_policy) | resource |
| [aws_ecr_repository.statsite](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/ecr_repository) | resource |
| [aws_iam_role.ecs_task_role](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role) | resource |
| [aws_iam_role_policy.cloudwatch_metrics_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role_policy) | resource |
| [aws_iam_role_policy_attachment.jenkins_role_ecr_poweruser](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role_policy_attachment) | resource |

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_env"></a> [env](#input\_env) | The stack environment. One of dev, staging, or prod | `string` | n/a | yes |
| <a name="input_graphite_url"></a> [graphite\_url](#input\_graphite\_url) | The URL for the graphite endpoint. | `string` | n/a | yes |
| <a name="input_owner"></a> [owner](#input\_owner) | The email address of the owner of this account | `string` | n/a | yes |
| <a name="input_pagerduty_sns_topic_arns"></a> [pagerduty\_sns\_topic\_arns](#input\_pagerduty\_sns\_topic\_arns) | An list of SNS topic ARNs that has a pagerduty integration subscribed to it. | `list(string)` | n/a | yes |
| <a name="input_region"></a> [region](#input\_region) | The AWS region to deploy this stack to | `string` | n/a | yes |
| <a name="input_security_groups"></a> [security\_groups](#input\_security\_groups) | The security groups to associate this stack to | `list(string)` | n/a | yes |
| <a name="input_statsd_proxy_asg_instances"></a> [statsd\_proxy\_asg\_instances](#input\_statsd\_proxy\_asg\_instances) | The desired cluster size for statsd-proxy | `number` | `9` | no |
| <a name="input_statsd_proxy_image_tag"></a> [statsd\_proxy\_image\_tag](#input\_statsd\_proxy\_image\_tag) | The image hash/tag that will be used to run statsd-proxy | `string` | n/a | yes |
| <a name="input_statsite_cluster_size"></a> [statsite\_cluster\_size](#input\_statsite\_cluster\_size) | The desired cluster size for statsite | `number` | `12` | no |
| <a name="input_statsite_image_tag"></a> [statsite\_image\_tag](#input\_statsite\_image\_tag) | The image hash/tag that will be used to run statsite | `string` | n/a | yes |
| <a name="input_subnets"></a> [subnets](#input\_subnets) | The subnets to deploy this stack to | `list(string)` | n/a | yes |
| <a name="input_team"></a> [team](#input\_team) | The name of the team owning this infrastructure | `string` | n/a | yes |
| <a name="input_vpc_id"></a> [vpc\_id](#input\_vpc\_id) | The VPC to deploy this stack to | `string` | n/a | yes |

### Outputs

| Name | Description |
|------|-------------|
| <a name="output_statsd_proxy_lb"></a> [statsd\_proxy\_lb](#output\_statsd\_proxy\_lb) | The statsdproxy endpoint address for sending metrics to |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.

### Known Issues

You may encounter the following issues when `terraform validate` part of the `pre-commit` hook is executed:

* `terraform` AWS provider requires a region to be set when `terraform validate` is being performed. If a region not set related error is prompted, set `export AWS_REGION=us-west-2` in your current terminal session.
* When trying to validate modules under the `modules` folder, `terraform init` needs to be executed in each module folder for the `pre-commit` to successfully validate each individual modules.
