# Primary application ASG and ELB

# TODO: remove after state is updated not to rely on this.
provider "template" {}


locals {
  ami = coalesce(var.ami, data.aws_ami.ecs_ami.id)
}

data "aws_region" "current" {}

data "aws_ami" "ecs_ami" {
  most_recent = true

  owners = ["amazon"]

  // Note: If the name pattern on https://docs.aws.amazon.com/AmazonECS/latest/developerguide/al2ami.html
  //       is ever updated, we need to change this filter
  filter {
    name   = "name"
    values = ["amzn2-ami-ecs-hvm-*-x86_64-ebs"]
  }
}

resource "aws_launch_configuration" "app_conf" {
  name_prefix     = "${var.team}-${var.environment}-${var.name}"
  image_id        = local.ami
  instance_type   = var.instance_type
  security_groups = split(",", var.security_groups)
  user_data = templatefile("${path.module}/asg_userdata.template", {
    ecs_cluster_name            = var.cluster_name
    environment                 = var.environment
    ssm_agent_loggroup          = var.ssm_agent_loggroup
    ecs_agent_loggroup          = var.ecs_agent_loggroup
    ecs_init_loggroup           = var.ecs_init_loggroup
    attribute_json              = jsonencode(var.instance_attributes)
    task_cleanup_wait_duration  = var.task_cleanup_wait_duration
    task_shutdown_wait_duration = var.task_shutdown_wait_duration
  })

  key_name             = var.host_key_name
  iam_instance_profile = var.container_instance_profile_id

  root_block_device {
    volume_size = var.root_volume_size
  }

  lifecycle {
    create_before_destroy = true
  }
}

resource "aws_autoscaling_group" "app_asg" {
  name_prefix         = "${var.team}-${var.environment}-${var.name}"
  vpc_zone_identifier = split(",", var.vpc_zone_identifier)

  max_size         = var.max_size
  min_size         = 0 # Set 0 to allow the ECS Capacity Provider full autonomy over the ASG.
  desired_capacity = var.desired_capacity

  health_check_grace_period = 30 # seconds
  default_cooldown          = 30 # seconds
  protect_from_scale_in     = true
  launch_configuration      = aws_launch_configuration.app_conf.name

  tag {
    key                 = "Name"
    value               = var.name
    propagate_at_launch = true
  }

  tag {
    key                 = "Environment"
    value               = var.environment
    propagate_at_launch = true
  }

  tag {
    key                 = "Owner"
    value               = var.owner
    propagate_at_launch = true
  }

  tag {
    key                 = "Team"
    value               = var.team
    propagate_at_launch = true
  }

  // If we don't ignore this, then each rerun of terraform resets the desired capacity if it ever auto scaled
  lifecycle {
    ignore_changes = [desired_capacity]
  }
}

output "arn" {
  value = aws_autoscaling_group.app_asg.arn
}
