variable "vpc_id" {
  description = "The vpc id of the cluster"
  type        = string
}

variable "subnets" {
  description = "VPC subnets to be associated"
  type        = list(string)
}

variable "security_groups" {
  description = "Security groups to attach"
  type        = list(string)
}

variable "cluster_size" {
  description = "The max, and desired number of EC2 instances to run."
  type        = object({ max = number, desired = number })
}

variable "environment" {
  description = "A name for the environment that this statsite cluster serves"
  type        = string
}

variable "app_port" {
  description = "Container port that statsite should serve from."
  type        = number
  default     = 8125
}

variable "cluster_name" {
  description = "A name for the cluster that is served by this statsite"
  type        = string
}

variable "image_url" {
  description = "URL to a docker image for statsite"
  type        = string
}

variable "ecs_task_role_arn" {
  description = "The ARN of the ECS task role that allows the app to call other AWS services."
  type        = string
}

variable "owner_email" {
  description = "The email of the owning group, tagged in the ASG."
  type        = string
}

variable "service_iam_role" {
  description = "The ARN of the IAM role for the ECS service."
  type        = string
}

variable "container_instance_profile_id" {
  description = "The permissions ID these hosts get. Should probably use the one created by core."
  type        = string
}

variable "log_group" {
  description = "Name of the log group to be used by go-statsd-proxy."
  type        = string
}

variable "region" {
  description = "The region of statsite deployment."
  type        = string
}

variable "graphite_host" {
  description = "The downstream graphite host name."
  type        = string
}

variable "graphite_port" {
  description = "Port statsite will use to connect to the downstream graphite host."
  type        = number
}

variable "flush_interval" {
  description = "How often, in seconds, that statsite should flush stats to the downstream graphite(or carbon relay)."
  type        = number
  default     = 10
}

variable "alarm_threshold" {
  description = "Threshold to alert on metrics processed over a 60s period."
  type        = number
  default     = 0 # Alarm disabled by default
}

variable "instance_type" {
  description = "Which AWS instance type to use a container instance."
  type        = string
}

variable "tasks_per_instance" {
  description = "How many statsite tasks to run per container instance. Typically, this should match the number of vCPUs from `instance_type`."
  type        = string
  default     = 1
}

variable "memory" {
  description = "How much memory (in MB) to limit each statsite instance to."
  type        = string
}

variable "app_name" {
  description = "application name"
  type        = string
  default     = "plumbago"
}

variable "stage" {
  description = "deploy stage (example: dev, production)"
  type        = string
  default     = "dev"
}

variable "pagerduty_sns_topic_arns" {
  type        = list(string)
  description = "An list of SNS topic ARNs that has a pagerduty integration subscribed to it."
}
