variable "vpc_id" {
  type        = string
  description = "The VPC to deploy this stack to"
}

variable "subnets" {
  type        = list(string)
  description = "The subnets to deploy this stack to"
}

variable "security_groups" {
  type        = list(string)
  description = "The security groups to associate this stack to"
}

variable "region" {
  type        = string
  description = "The AWS region to deploy this stack to"
}

variable "env" {
  type        = string
  description = "The stack environment. One of dev, staging, or prod"
}

variable "statsd_proxy_asg_instances" {
  type        = number
  description = "The desired cluster size for statsd-proxy"
  default     = 9
}

variable "statsite_cluster_size" {
  type        = number
  description = "The desired cluster size for statsite"
  default     = 12
}

variable "graphite_url" {
  description = "The URL for the graphite endpoint."
  type        = string
}

variable "statsd_proxy_image_tag" {
  type        = string
  description = "The image hash/tag that will be used to run statsd-proxy"
}

variable "statsite_image_tag" {
  type        = string
  description = "The image hash/tag that will be used to run statsite"
}

variable "pagerduty_sns_topic_arns" {
  type        = list(string)
  description = "An list of SNS topic ARNs that has a pagerduty integration subscribed to it."
}

variable "owner" {
  type        = string
  description = "The email address of the owner of this account"
}

variable "team" {
  type        = string
  description = "The name of the team owning this infrastructure"
}

locals {
  account = var.team

  tags = {
    Owner       = var.owner
    Environment = var.env
    Service     = "${var.team}-pipeline"
  }
}
