## Adding a VPC endpoint

Audience: Folks who will consume your VPC endpoint service (i.e: those who will create an endpoint connection to your VPC endpoint service).

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**  *generated with [DocToc](https://github.com/thlorenz/doctoc)*

- [Terraform](#terraform)
- [Manually (AWS console)](#manually-aws-console)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Terraform

See the [terraform docs](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/vpc_endpoint) for the most up to date reference.

Quick ex with consul's vpc endpoint service in eu-west-2:
```hcl
resource "aws_vpc_endpoint" "ptfe_service" {
  vpc_id            = "<vpc-of-my-target-acc>"
  service_name      = "com.amazonaws.vpce.eu-west-2.vpce-svc-0f3d8760236542eaf"
  vpc_endpoint_type = "Interface"

  security_group_ids = [
    <sg-of-my-target-acc>,
  ]

  subnet_ids          = [<subnets-in-my-vpc>]
  private_dns_enabled = true
}
```

## Manually (AWS console)

Log onto the AWS console of your service account. Under VPC --> Endpoints, click "Create Endpoint":

![](imgs/vpc_endpoint_pg.png)

In the following page, select the bubble for `Find Service By Name` under the **Service Category** section. Under **Service Name**, fill in the name of the VPC endpoint service created (i.e: `com.amazonaws....`).

![](imgs/create_endpoint_1.png)

Click "Verify". If the endpoint service provider successfully allowlisted your account's principal, the verification should be successful. Fill in the VPC, subnet, and security group information of the VPC and subnets you'd like connectivity to the endpoint service with. Additionally, make sure to check the box for "Enable DNS Name".

![](imgs/create_endpoint_2.png)

Optionally, set any identifying metadata tags you'd like. Once complete, click `Create Endpoint` at the bottom of the page. It'll take a couple of minutes for the underlying ENIs to be created but once successfully created, the console will show the endpoint as available when complete. Verify connectivity by calling a service the endpoint service provides in your target VPC. (e.g: `curl whatever.api.was.exposed.live-video.a2z.com`).
