# tf-mod-vpce-service
Module to configure and create a VPCe service. ELBs not included (but lambda glue is)!

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Setting Private DNS (Manual)](#setting-private-dns-manual)
- [Enabling VPC endpoint connection to other accounts](#enabling-vpc-endpoint-connection-to-other-accounts)
- [Updating NLB -> ALB](#updating-nlb---alb)
- [Terraform](#terraform)
  - [Requirements](#requirements)
  - [Providers](#providers)
  - [Resources](#resources)
  - [Inputs](#inputs)
  - [Outputs](#outputs)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Setting Private DNS (Manual)

In version 1.1.0 and below of this module, the aws_vpc_endpoint_service resource does not support resources related to setting custom [private DNS names](https://docs.aws.amazon.com/vpc/latest/userguide/vpce-interface.html#vpce-private-dns) for domains you own attached to your VPC endpoint [AWS tf provider issue](https://github.com/terraform-providers/terraform-provider-aws/issues/11510).

Once this module creates your VPCe, to configure a private DNS name for your endpoint, go to VPC --> Endpoint Services in the AWS console. Find your VPC endpoint service and click on it checkbox and select "Modify Private DNS Name" under "Actions"

![](imgs/modify_dns.png)

Once you click that image, check the box for "Enable private DNS name
" and enter the fully qualified domain name of your VPC endpoint service into the "Private DNS Name" text box. Ensure you are authoritative for the subdomain before clicking "Modify". (NOTE: the example defines a DNS name that says "vpce" in it, but in reality, the name may be the exact same as the existing service endpoint you use now. ex: `kinesis.us-east-1.amazonaws.com` or `api.us-west-2.prod.consul.live-video.a2z.com`).

![](imgs/modify_page.png)

On the original page, under the "Details" tab when you select your VPC endpoint service, find the values for "Domain verification [name|value]". Take those values to create a TXT record in the Route 53 console of the subdomain you created the endpoint for. The domain verification status is tracked under the Details tab for the VPC endpoint service as well under "Domain verification status". It may take roughly 15 minutes for verification to occur.

![](imgs/domain_verify.png)

## Enabling VPC endpoint connection to other accounts

This is detailed in the terraform arguments already, but to emphasize, the VPC endpoint service created by this module will automatically accept any requests from accounts that you specify with the `allowed_principals` argument. Use a list of account ARNs formatted as such `arn:aws:iam::<ACC_NUM>:root`
to enable access of your endpoint service to another account.

## Updating NLB -> ALB

The latest package is built based from [FultonAlbBehindNlbLambdaPython](https://code.amazon.com/packages/FultonAlbBehindNlbLambdaPython/trees/mainline). To build a new zip, run the following:

```bash
# Assuming brazil workspace lives in ~/workspaces
cd ~/workspaces
brazil ws create --name FultonAlbBehindNlbLambdaPython

cd FultonAlbBehindNlbLambdaPython
brazil ws use --package FultonAlbBehindNlbLambdaPython

cd src/FultonAlbBehindNlbLambdaPython/
brazil setup platform-support
brazil-build
bats transform --transformer AWSLambda-1.0  --target FultonAlbBehindNlbLambdaPython-1.0 --parameter FultonAlbBehindNlbLambdaPython-1.0

# A new zip file should be build. Overwrite lambda/populate_NLB_TG_with_ALB.zip with the following zip
> ls -lh *.zip
-rw-r--r--  1 toachris  wheel   740K Apr 15 16:28 aws_lambda.bundle.primary.4eb3c55945124d19accbbaa43d4c8bba.zip
```

## Terraform

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
### Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >=0.14.7 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | >= 3.23.0 |
| <a name="requirement_template"></a> [template](#requirement\_template) | >= 2.1 |

### Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | 3.53.0 |

### Resources

| Name | Type |
|------|------|
| [aws_lb.input_alb](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/lb) | data source |

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_acceptance_required"></a> [acceptance\_required](#input\_acceptance\_required) | Whether or not manual confirmation is needed to accept the endpoint service. Default is false. Permissions gated by allowed\_principals. | `bool` | `false` | no |
| <a name="input_alb_arn"></a> [alb\_arn](#input\_alb\_arn) | The ARN of an existing ALB that will be attached to the NLB. Must be inputted if attach\_alb is set to true. | `string` | n/a | yes |
| <a name="input_alb_listener_port"></a> [alb\_listener\_port](#input\_alb\_listener\_port) | The port of an existing LB listener that is associated with the inputted ALB. Must be inputted if attach\_alb is set to true. | `string` | `443` | no |
| <a name="input_allowed_principals"></a> [allowed\_principals](#input\_allowed\_principals) | A list of principal ARNs that are allowed to automatically connect to your endpoint service. | `list(string)` | `[]` | no |
| <a name="input_enable_vpce_service"></a> [enable\_vpce\_service](#input\_enable\_vpce\_service) | If set to true, will allow creation of a VPCE service. If set to false, no VPCE service will be created, but the other resources will be. | `bool` | n/a | yes |
| <a name="input_nlb_arn"></a> [nlb\_arn](#input\_nlb\_arn) | The ARN of an existing NLB the VPCe service will be associated with. | `string` | n/a | yes |
| <a name="input_nlb_tg_arn"></a> [nlb\_tg\_arn](#input\_nlb\_tg\_arn) | The ARN of a target group associated with the NLB will forward traffic to. | `string` | `""` | no |
| <a name="input_private_dns_name"></a> [private\_dns\_name](#input\_private\_dns\_name) | The private DNS name for the service. | `string` | `""` | no |
| <a name="input_region"></a> [region](#input\_region) | The AWS region. | `string` | n/a | yes |
| <a name="input_service_id"></a> [service\_id](#input\_service\_id) | A unique service identifier that will help identify resources created. | `string` | n/a | yes |
| <a name="input_tags"></a> [tags](#input\_tags) | An optional map of tags to be attached on created resources. | `map` | `{}` | no |

### Outputs

| Name | Description |
|------|-------------|
| <a name="output_private_dns_name_configuration"></a> [private\_dns\_name\_configuration](#output\_private\_dns\_name\_configuration) | Information about the endpoint service private DNS name configuration |
| <a name="output_vpce_service_dns_name"></a> [vpce\_service\_dns\_name](#output\_vpce\_service\_dns\_name) | The base DNS name of the VPC endpoint service created. |
| <a name="output_vpce_service_name"></a> [vpce\_service\_name](#output\_vpce\_service\_name) | The service name of the VPC endpoint service created. Used by consumers of the VPCe to discover the VPCe. |
| <a name="output_vpce_service_private_dns_name"></a> [vpce\_service\_private\_dns\_name](#output\_vpce\_service\_private\_dns\_name) | The private DNS name of the VPC endpoint service created. |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
