output "vpce_service_name" {
  description = "The service name of the VPC endpoint service created. Used by consumers of the VPCe to discover the VPCe."
  value       = var.enable_vpce_service ? aws_vpc_endpoint_service.vpce_service[0].service_name : ""
}

output "vpce_service_private_dns_name" {
  description = "The private DNS name of the VPC endpoint service created."
  value       = var.enable_vpce_service ? aws_vpc_endpoint_service.vpce_service[0].private_dns_name : ""
}

output "vpce_service_dns_name" {
  description = "The base DNS name of the VPC endpoint service created."
  value       = var.enable_vpce_service ? aws_vpc_endpoint_service.vpce_service[0].base_endpoint_dns_names : [""]
}

output "private_dns_name_configuration" {
  description = "Information about the endpoint service private DNS name configuration"
  value       = var.enable_vpce_service ? try(aws_vpc_endpoint_service.vpce_service[0].private_dns_name_configuration[0], { name = "", value = "", type = "TXT" }) : {}
}
