variable "service_id" {
  type        = string
  description = "A unique service identifier that will help identify resources created."
}

variable "region" {
  type        = string
  description = "The AWS region."
}

variable "nlb_arn" {
  type        = string
  description = "The ARN of an existing NLB the VPCe service will be associated with."
}

variable "nlb_tg_arn" {
  type        = string
  description = "The ARN of a target group associated with the NLB will forward traffic to."
  default     = ""
}

variable "alb_arn" {
  type        = string
  description = "The ARN of an existing ALB that will be attached to the NLB. Must be inputted if attach_alb is set to true."
}

variable "alb_listener_port" {
  type        = string
  description = "The port of an existing LB listener that is associated with the inputted ALB. Must be inputted if attach_alb is set to true."
  default     = 443
}

variable "acceptance_required" {
  type        = bool
  default     = false
  description = "Whether or not manual confirmation is needed to accept the endpoint service. Default is false. Permissions gated by allowed_principals."
}

variable "allowed_principals" {
  type        = list(string)
  description = "A list of principal ARNs that are allowed to automatically connect to your endpoint service."
  default     = []
}

variable "tags" {
  description = "An optional map of tags to be attached on created resources."
  default     = {}
}

variable "private_dns_name" {
  type        = string
  description = "The private DNS name for the service."
  default     = ""
}

variable "enable_vpce_service" {
  type        = bool
  description = "If set to true, will allow creation of a VPCE service. If set to false, no VPCE service will be created, but the other resources will be."
}
