# Build and Testing

## Build the image
* Run `make`
This takes a few minutes and will generate several files in the output directory (kernel, initramfs and squashfs image [which contains the actual OS])
```
output/ubuntu-<lsb_release>-<kernel_version>-vmlinuz
output/ubuntu-<lsb_release>-<kernel_version>.squashfs
output/ubuntu-<lsb_release>-<kernel_version>-initrd
```

## Testing

Please note that by default netboot image has support only for the ldap authentication and root ssh logins are disabled. To enable root ssh logins please use `prepare-boot.sh` script. This script will:
* create output/boot.ipxe with twitch\_hook url as a kernel parameter. If present this url is sourced by the netboot image after the boot
* generate output/post-boot script that will add public ssh key for the root user and will enable root ssh logins

`prepare-boot.sh` is run as part of the build so you don't need to run it for local testing.

### Vagrant
There are 2 vagrant boxes to enable local testing of the netboot image once you have successfully ran make.
#### web box
This box is used to serve files from the output directory via http to the pxe box (see below). To start the web box up, run:
```
vagrant up web
```

#### pxe box
This box is used to test PXE booting the netboot image. To start the pxe box, run:
```
vagrant up pxe
```

#### shortcuts
```
vagrant up
```
to run both machines.

### Validating the pxe box
#### virtualbox gui
You should be able to attach to the console via virtualbox gui. If there are any issues with the PXE process, this is the best place to see that. You should see a `login:` prompt on the console if the boot process was successful.
#### Serial console log
The console in the pxe box has been redirected to the `serial.log` file. This file gets truncated each time the pxe box boots up/powercycles/reboots/etc. Best to review this file after each make to validate the boot process.
```
less -RIMS serial.log
```
#### ssh
Once booted, you should be able to ssh the pxe box with the vagrant or ssh command:
```
vagrant ssh pxe
```
or
```
ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o GlobalKnownHostsFile=/dev/null -p $PORT $USERNAME@127.0.0.1
```
Replace $USERNAME with your ldap username. Replace $PORT with the port number vagrant is redirecting the ssh port to. <insert instructions on how to find $PORT>

## Deploy
### Provisioner (manual, until we build CD for this)
Each successful jenkins build of the netboot image (whether to a branch or the master branch) will emit a build tag that references a key in an S3 bucket provisioner has access to. The build tag is a combination of `${commit_date}-${GitSHA}-${JENKINS_BUILD_ID}`.

You can find the build ID of your most recent build by finding the substring `name_url=http://s3-reverse-proxy` in any successful jenkins build.

In the example below, this build to master https://jenkins-og.xarth.tv/job/video-coreservices/job/transcode_ubuntu_image/job/master/94/console emits the following line in the console:

```shell
11:07:13 + name_url=http://s3-reverse-proxy.us-west-2.prod.provisioner.live-video.a2z.com/jenkins/transcode_ubuntu_image/20200731180712-e47fdb7-94/ubuntu-xenial-4.15.0-54-initrd
```

The build tag for this example is `20200731180712-e47fdb7-94`.

To update the existing target (netboot/xenial), update the `build_tag` param for [this target](https://provisioner.video.xarth.tv/web/target/141) to the build tag you found for your build and click the green checkbox to the right of param to persist your change.

To create a new target (netboot/<my_new_target>), add a new child target under [this target](https://provisioner.video.xarth.tv/web/target/140) by filling out a new target name and description and pressing the "Add New Child Target" button at the bottom of the page. Then, on that new child target's page, add a param called `build_tag` and set the value to your build tag using the `new_param_name` and `new_param_value` boxes and click "Add Param" at the bottom of the page.

### Provisioner (jenkins/CD)
None yet.

#### Netbooting a host
* Make sure the host is powered off. There are several way of doing this. Here are some examples of how to do this (but not all)
   ```shell
   ipmipower -h ${IPMI_IP_ADDRESS_OF_HOST} --off
   ```
   ```shell
   ssh conman.internal.justin.tv
   conman 15ed0a70-357a-351c-bbce-a1d43e855445
   ```
   Then send the SysRq key sequence to reboot `&Bo`. 
* Set the host to PXE boot the new image (defaults)
   ```shell
   provision -i 15ed0a70-357a-351c-bbce-a1d43e855445 -r video-cs-netboot --target=bionic --environment=netboot
   ```
* Set the host to PXE boot the new image (your custom target)
  ```shell
  provision -i 15ed0a70-357a-351c-bbce-a1d43e855445 -r video-cs-netboot --target=<my_new_target> --environment=netboot
  ```
